/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.selector;

import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.protocol.IConnection;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectServerWizard
extends Wizard {
    private MServerProfile value;

    public SelectServerWizard() {
        this.setWindowTitle("JasperReports Servers");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)new Page());
    }

    public MServerProfile getValue() {
        return this.value;
    }

    public boolean performFinish() {
        try {
            if (this.value != null) {
                this.getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Testing connection", -1);
                        try {
                            IConnection c = SelectServerWizard.this.value.getWsClient(monitor);
                            if (c == null) {
                                throw new Exception("Could not connect to this server");
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
            return false;
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e);
            return false;
        }
        return true;
    }

    class Page
    extends WizardPage {
        protected Page() {
            super("serverpage");
            this.setTitle("Select a JasperReports Server");
            this.setDescription("There is no JasperReports Server connection for this report. Please select one to continue.");
        }

        public void createControl(Composite parent) {
            Composite cmp = new Composite(parent, 0);
            cmp.setLayout((Layout)new GridLayout());
            this.setControl((Control)cmp);
            final TableViewer tv = new TableViewer(cmp, 68356);
            GridData gd = new GridData(1808);
            gd.widthHint = 300;
            gd.heightHint = 300;
            tv.getTable().setLayoutData((Object)gd);
            tv.getTable().setHeaderVisible(false);
            tv.getTable().setLinesVisible(false);
            tv.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            tv.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tv, (int)2);
            tv.setInput(ServerManager.getServerProfiles());
            tv.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ((Page)Page.this).SelectServerWizard.this.value = (MServerProfile)((Object)((StructuredSelection)tv.getSelection()).getFirstElement());
                }
            });
            tv.getTable().select(0);
            SelectServerWizard.this.value = (MServerProfile)((Object)((StructuredSelection)tv.getSelection()).getFirstElement());
        }
    }
}

