/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import net.sf.jasperreports.util.Base64Util;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.json.JSONObject;

public class Encrypter {
    Cipher ecipher;
    Cipher dcipher;
    byte[] salt = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
    int iterationCount = 19;

    public Encrypter(String passPhrase) {
        try {
            DESKeySpec keySpec = new DESKeySpec(passPhrase.getBytes());
            SecretKey key = SecretKeyFactory.getInstance("DES").generateSecret(keySpec);
            this.ecipher = Cipher.getInstance("DES");
            this.dcipher = Cipher.getInstance("DES");
            this.ecipher.init(1, key);
            this.dcipher.init(2, key);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
    }

    public String encrypt(String str) {
        try {
            byte[] utf8 = str.getBytes(StandardCharsets.UTF_8);
            byte[] enc = this.ecipher.doFinal(utf8);
            return Encrypter.encodeBase64(enc);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decrypt(String str) {
        try {
            byte[] dec = this.decodeBase64(str);
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, StandardCharsets.UTF_8);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String encodeBase64(byte[] bytes) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Base64Util.encode((InputStream)new ByteArrayInputStream(bytes), (OutputStream)os);
            return os.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private byte[] decodeBase64(String s) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Base64Util.decode((InputStream)new ByteArrayInputStream(s.getBytes()), (OutputStream)os);
            return os.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String byteArrayToHexString(byte[] byteArr) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = byteArr;
        int n = byteArr.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(Character.forDigit((b & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(b & 0xF, 16));
            ++n2;
        }
        return sb.toString();
    }

    private static PublicKey getPublicKey(String n, String e) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        int radix = 16;
        BigInteger modulus = new BigInteger(n, radix);
        BigInteger publicExponent = new BigInteger(e, radix);
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
        return keyFactory.generatePublic(publicKeySpec);
    }

    public static String encryptRSA(String pass, String key) {
        try {
            JSONObject jo = new JSONObject(key);
            PublicKey k = Encrypter.getPublicKey(jo.getString("n"), jo.getString("e"));
            Cipher c = Cipher.getInstance("RSA/NONE/NoPadding", (Provider)new BouncyCastleProvider());
            c.init(1, k);
            pass = URLEncoder.encode(pass, "UTF-8");
            return Encrypter.byteArrayToHexString(c.doFinal(pass.getBytes()));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return pass;
        }
    }
}

