/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard;

import com.jaspersoft.studio.data.adapter.JSSDescriptor;
import com.jaspersoft.studio.data.wizard.ListInstallationPage;
import com.jaspersoft.studio.data.wizard.SelectWorkspacePage;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.preferences.util.PreferencesUtils;
import com.jaspersoft.studio.repository.RepositoryView;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.action.server.EditServerAction;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.model.server.MServers;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.preferences.CASListFieldEditor;
import com.jaspersoft.studio.server.preferences.SSOServer;
import com.jaspersoft.studio.server.wizard.pages.ShowServersPage;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.CastorHelper;
import net.sf.jasperreports.eclipse.util.SecureStorageUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.exolab.castor.mapping.Mapping;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ImportJSSServersWizard
extends Wizard
implements IImportWizard {
    ListInstallationPage page0 = new SelectWorkspacePage();
    ListJSSServer page1 = new ListJSSServer();

    public void addPages() {
        this.addPage((IWizardPage)this.page0);
        this.addPage((IWizardPage)this.page1);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private RepositoryView getRepositoryView() {
        return (RepositoryView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.jaspersoft.studio.Repository");
    }

    public boolean performFinish() {
        String currentServersProp = PreferencesUtils.getJaspersoftStudioPrefStore().getString("com.jaspersoft.studio.server.sso");
        List<SSOServer> currentServers = ShowServersPage.getCASServers(currentServersProp);
        for (SSOServer server : this.page1.getSSOToImport()) {
            currentServers.add(server);
        }
        String v = "";
        for (SSOServer srv : currentServers) {
            v = String.valueOf(v) + Base64.encodeBase64String((byte[])CastorHelper.write((Object)srv, (Mapping)CASListFieldEditor.getMapping()).getBytes()) + "\n";
            try {
                if (srv.getPassuuid() == null) continue;
                SecureStorageUtils.saveToDefaultSecurePreferences((String)"com.jaspersoft.studio.jrserver", (String)srv.getPassuuid(), (String)srv.getPassword());
            }
            catch (StorageException e) {
                e.printStackTrace();
            }
        }
        PreferencesUtils.getJaspersoftStudioPrefStore().setValue("com.jaspersoft.studio.server.sso", v);
        RepositoryView view = this.getRepositoryView();
        TreeViewer treeViewer = null;
        MServers serversNode = null;
        if (view != null) {
            treeViewer = view.getTreeViewer();
            MRoot root = (MRoot)treeViewer.getInput();
            List lst = root.getChildren();
            for (INode n : lst) {
                if (!(n instanceof MServers)) continue;
                serversNode = (MServers)n;
                break;
            }
        }
        List<ServerProfile> servers = this.page1.getSelectedServers();
        for (ServerProfile srv : servers) {
            MServerProfile mservprof = new MServerProfile(null, srv);
            if (serversNode == null) {
                ServerManager.addServerProfile(mservprof);
                continue;
            }
            MServerProfile newprofile = new MServerProfile(serversNode, mservprof.getValue());
            newprofile.setWsClient(null);
            ServerManager.addServerProfile(newprofile);
            EditServerAction.fillServerProfile(newprofile, treeViewer);
        }
        return true;
    }

    private class ListJSSServer
    extends ShowServersPage {
        private ListJSSServer() {
        }

        private List<ServerProfile> getPropertyProfiles(Properties prop) {
            File[] serversFileStorage;
            Document document;
            ArrayList<ServerProfile> result = new ArrayList<ServerProfile>();
            String xmlString = prop.getProperty("serverprofiles");
            if (xmlString == null) {
                return result;
            }
            try {
                document = JRXmlUtils.parse((InputSource)new InputSource(new StringReader(xmlString)));
                Node actualNode = document.getFirstChild();
                actualNode = actualNode.hasChildNodes() ? actualNode.getFirstChild() : null;
                while (actualNode != null) {
                    if (actualNode.getNodeName().equals("serverProfile")) {
                        Node child = actualNode.getFirstChild();
                        while (child != null) {
                            ServerProfile sprof = (ServerProfile)CastorHelper.read((Node)child, (String)"com/jaspersoft/studio/server/model/server/ServerProfileImpl.xml");
                            result.add(sprof);
                            child = child.getNextSibling();
                        }
                    }
                    actualNode = actualNode.getNextSibling();
                }
            }
            catch (JRException e) {
                e.printStackTrace();
            }
            JSSDescriptor jssInstallation = (JSSDescriptor)this.selectedInstallation;
            File[] fileArray = serversFileStorage = jssInstallation.getStorageResources("serverprofiles");
            int n = serversFileStorage.length;
            int n2 = 0;
            while (n2 < n) {
                File fileServer = fileArray[n2];
                try {
                    document = JRXmlUtils.parse((File)fileServer);
                    Node actualNode = document.getFirstChild();
                    if (actualNode.getNodeName().equals("serverProfile")) {
                        Node child = actualNode.getFirstChild();
                        while (child != null) {
                            ServerProfile sprof = (ServerProfile)CastorHelper.read((Node)child, (String)"com/jaspersoft/studio/server/model/server/ServerProfileImpl.xml");
                            result.add(sprof);
                            child = child.getNextSibling();
                        }
                    }
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            return result;
        }

        private List<ServerProfile> getPropertyProfiles(File[] configurationFiles) {
            ArrayList<ServerProfile> result = new ArrayList<ServerProfile>();
            File[] fileArray = configurationFiles;
            int n = configurationFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File storageElement = fileArray[n2];
                try {
                    FileInputStream inputStream = new FileInputStream(storageElement);
                    InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    InputSource is = new InputSource(reader);
                    is.setEncoding("UTF-8");
                    Document document = JRXmlUtils.parse((InputSource)is);
                    Element serverNode = document.getDocumentElement();
                    if (serverNode.getNodeType() == 1) {
                        try {
                            ServerProfile sprof = (ServerProfile)CastorHelper.read((Node)serverNode, (String)"com/jaspersoft/studio/server/model/server/ServerProfileImpl.xml");
                            result.add(sprof);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    UIUtils.showError((Throwable)e);
                }
                ++n2;
            }
            return result;
        }

        @Override
        protected List<ServerProfile> createCheckBoxData(Properties prop) {
            ArrayList<ServerProfile> result = new ArrayList<ServerProfile>();
            result.addAll(this.getPropertyProfiles(prop));
            if (this.selectedInstallation instanceof JSSDescriptor) {
                JSSDescriptor jssInstallation = (JSSDescriptor)this.selectedInstallation;
                File[] serverConfigurations = jssInstallation.getStorageResources("serverprofiles");
                result.addAll(this.getPropertyProfiles(serverConfigurations));
            }
            return result;
        }

        @Override
        protected String getContextName() {
            return ContextHelpIDs.WIZARD_IMPORT_WORKSPACE;
        }
    }
}

