/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.pages;

import com.jaspersoft.studio.server.messages.Messages;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class UsernameValidator
implements IValidator {
    private boolean allowNull = false;
    private static final char[] NOT_ALLOWED_ID_CHARS = new char[]{'\\', '|', ' ', '`', '\"', '\'', '~', '!', '#', '$', '%', '^', '&', '[', ']', '*', '+', '=', ';', ':', '?', '<', '>', '}', '{', ')', '(', ']', '[', '/'};

    public UsernameValidator() {
    }

    public UsernameValidator(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public IStatus validate(Object value) {
        String uname = (String)value;
        if (value == null || uname.isEmpty()) {
            if (this.allowNull) {
                return Status.OK_STATUS;
            }
            return ValidationStatus.error((String)Messages.EmptyStringValidator_EmptyError);
        }
        if (uname.length() > 100) {
            return ValidationStatus.error((String)Messages.UsernameValidator_ErrorMsgUsernameTooLong);
        }
        char[] cArray = uname.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isSpaceChar(c)) {
                if (ArrayUtils.contains((char[])NOT_ALLOWED_ID_CHARS, (char)c)) {
                    return ValidationStatus.error((String)Messages.UsernameValidator_ErrorMsgNotAllowedChars);
                }
            } else {
                return ValidationStatus.error((String)Messages.UsernameValidator_ErrorMsgNoSpaceChars);
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }
}

