/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MReference;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.wizard.resource.page.AddResourcePage;
import com.jaspersoft.studio.server.wizard.resource.page.ResourceDescriptorPage;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class AddResourceWizard
extends Wizard {
    private AddResourcePage page0;
    private boolean skipFirstPage = false;
    private boolean nested = false;
    private boolean dsonly = false;
    private boolean ruOnly = false;
    private boolean monOnly = false;
    private boolean olapOnly = false;
    private ResourceFactory rfactory = new ResourceFactory();
    private Map<Class<? extends AMResource>, IWizardPage[]> pagemap = new HashMap<Class<? extends AMResource>, IWizardPage[]>();
    private ANode parent;
    private boolean canFinish = true;

    public AddResourceWizard(ANode parent, boolean nested) {
        this(parent);
        this.setNested(nested);
    }

    public AddResourceWizard(ANode parent) {
        this.setWindowTitle(Messages.AddResourceWizard_windowtitle);
        this.setNeedsProgressMonitor(true);
        this.parent = parent;
    }

    public void setNested(boolean nested) {
        this.nested = nested;
    }

    public void setSkipFirstPage(boolean skipFirstPage) {
        this.skipFirstPage = skipFirstPage;
    }

    public IWizardPage getStartingPage() {
        if (this.skipFirstPage && this.page0 != null) {
            return this.getNextPage((IWizardPage)this.page0);
        }
        return super.getStartingPage();
    }

    public void setOnlyDatasource(boolean dsonly) {
        this.dsonly = dsonly;
    }

    public void setOnlyReportUnit(boolean ruOnly) {
        this.ruOnly = ruOnly;
    }

    public void setMondrianOnly(boolean monOnly) {
        this.monOnly = monOnly;
    }

    public void setOlapOnly(boolean olapOnly) {
        this.olapOnly = olapOnly;
    }

    public void addPages() {
        this.page0 = new AddResourcePage(this.parent);
        this.page0.setOnlyDatasource(this.dsonly);
        this.page0.setOnlyReportUnit(this.ruOnly);
        this.page0.setMondrianOnly(this.monOnly);
        this.page0.setOlapOnly(this.olapOnly);
        this.addPage((IWizardPage)this.page0);
        this.addPage((IWizardPage)new ResourceDescriptorPage());
    }

    public IWizardPage getNextPage(IWizardPage page) {
        AMResource r;
        if (page == this.page0 && (r = this.page0.getResource()) != null) {
            int size = this.getPageCount();
            try {
                Field f = Wizard.class.getDeclaredField("pages");
                f.setAccessible(true);
                List wpages = (List)f.get((Object)this);
                int i = 1;
                while (i < size) {
                    wpages.remove(1);
                    ++i;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            IWizardPage[] rpage = this.pagemap.get(((Object)((Object)r)).getClass());
            if (rpage == null && (rpage = this.rfactory.getResourcePage(this.parent, r)) != null) {
                this.pagemap.put(((Object)((Object)r)).getClass(), rpage);
            }
            if (rpage != null) {
                IWizardPage firstpage = null;
                IWizardPage[] iWizardPageArray = rpage;
                int n = rpage.length;
                int n2 = 0;
                while (n2 < n) {
                    IWizardPage p = iWizardPageArray[n2];
                    if (this.getPage(p.getName()) == null) {
                        this.addPage(p);
                        if (firstpage == null) {
                            firstpage = p;
                        }
                    }
                    ++n2;
                }
                return firstpage;
            }
            return null;
        }
        return super.getNextPage(page);
    }

    public void dispose() {
        super.dispose();
        Iterator<IWizardPage[]> iterator = this.pagemap.values().iterator();
        while (iterator.hasNext()) {
            IWizardPage[] pages;
            IWizardPage[] iWizardPageArray = pages = iterator.next();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage p = iWizardPageArray[n2];
                p.dispose();
                ++n2;
            }
        }
    }

    public AMResource getResource() {
        return this.page0.getResource();
    }

    public boolean performFinish() {
        this.canFinish = true;
        if (this.nested) {
            return true;
        }
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.AddResourceWizard_1, -1);
                    try {
                        AMResource resource = AddResourceWizard.this.getResource();
                        ResourceDescriptor res = resource.getValue();
                        if (res.getIsNew()) {
                            res.setUriString(String.valueOf(res.getParentFolder()) + "/" + res.getName());
                            INode r = AddResourceWizard.this.parent.getRoot();
                            if (r instanceof MServerProfile) {
                                MServerProfile msp = (MServerProfile)r;
                                msp = ServerManager.getMServerProfileCopy(msp);
                                if (WSClientHelper.findSelected(monitor, resource.getValue(), msp) != null && !UIUtils.showConfirmation((String)Messages.AddResourceWizard_3, (String)Messages.AddResourceWizard_4)) {
                                    AddResourceWizard.this.canFinish = false;
                                    return;
                                }
                            }
                        }
                        try {
                            if (AddResourceWizard.this.parent instanceof MReportUnit && (resource instanceof MReference || resource.getValue().getIsReference())) {
                                MReportUnit mrunit = (MReportUnit)AddResourceWizard.this.parent;
                                WSClientHelper.refreshResource(mrunit, monitor);
                                ResourceDescriptor runit = mrunit.getValue();
                                mrunit.setValue(runit);
                                runit.getChildren().add(resource.getValue());
                                WSClientHelper.saveResource(mrunit, monitor);
                            } else {
                                resource.setParent(AddResourceWizard.this.parent, -1);
                                WSClientHelper.saveResource(resource, monitor);
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
            return false;
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e);
            return false;
        }
        return this.canFinish;
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.page0) {
            return false;
        }
        return super.canFinish();
    }
}

