/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.wizard.resource.APageContent;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.UIUtil;
import net.sf.jasperreports.eclipse.ui.validator.EmptyStringValidator;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class QueryPageContent
extends APageContent {
    public static final String[] LANGUAGES = new String[]{"sql", "hql", "domain", "sl", "HiveQL", "MongoDbQuery"};
    private boolean showLangs = true;
    private Text tsql;
    private Combo clang;
    private QProxy proxy;

    public QueryPageContent(ANode parent, AMResource resource, DataBindingContext bindingContext) {
        super(parent, resource, bindingContext);
    }

    public QueryPageContent(ANode parent, AMResource resource) {
        super(parent, resource);
    }

    public QueryPageContent(ANode parent, AMResource resource, boolean showLangs) {
        super(parent, resource);
        this.showLangs = showLangs;
    }

    @Override
    public String getPageName() {
        return "com.jaspersoft.studio.server.page.query";
    }

    @Override
    public String getName() {
        return Messages.RDQueryPage_textquery;
    }

    @Override
    public Control createContent(Composite parent) {
        Control createContentComposite = this.createContentComposite(parent, this.bindingContext, this.res.getValue(), this.res, this.showLangs);
        this.rebind();
        return createContentComposite;
    }

    public Control createContentComposite(Composite parent, DataBindingContext bindingContext, ResourceDescriptor r, AMResource res, boolean showLangs) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        if (showLangs) {
            UIUtil.createLabel((Composite)composite, (String)Messages.RDQueryPage_language);
            this.clang = new Combo(composite, 2048);
            this.clang.setItems(LANGUAGES);
            if (res.getWsClient().getServerInfo().getVersion().compareTo("7.8") > 0) {
                this.clang.add("jasperQL");
            }
        }
        UIUtil.createLabel((Composite)composite, (String)Messages.RDQueryPage_query);
        this.tsql = new Text(composite, 2624);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 100;
        gd.widthHint = 400;
        this.tsql.setLayoutData((Object)gd);
        return composite;
    }

    @Override
    protected void rebind() {
        ResourceDescriptor r = this.res.getValue();
        if (this.clang != null && !this.clang.isDisposed()) {
            this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.clang), PojoProperties.value((String)"language").observe((Object)this.getProxy(r)));
        }
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tsql), PojoProperties.value((String)"sql").observe((Object)r), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new EmptyStringValidator()), null);
    }

    @Override
    public boolean isPageComplete() {
        if (this.tsql == null || this.tsql.isDisposed() || this.tsql.getText() == null || Misc.isNullOrEmpty((String)this.tsql.getText().trim())) {
            return false;
        }
        return super.isPageComplete();
    }

    private QProxy getProxy(ResourceDescriptor rd) {
        if (this.proxy == null) {
            this.proxy = new QProxy();
        }
        this.proxy.setResourceDescriptor(rd);
        return this.proxy;
    }

    public static class QProxy {
        private ResourceDescriptor rd;

        public void setResourceDescriptor(ResourceDescriptor rd) {
            this.rd = rd;
        }

        public void setLanguage(String lang) {
            lang = ModelUtils.getLanguage((String)lang);
            this.rd.setResourceProperty("PROP_QUERY_LANGUAGE", lang);
        }

        public String getLanguage() {
            return this.rd.getResourcePropertyValue("PROP_QUERY_LANGUAGE");
        }
    }
}

