/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MAdHocDataView;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.protocol.restv2.DiffFields;
import com.jaspersoft.studio.server.utils.ValidationUtils;
import com.jaspersoft.studio.server.wizard.resource.APageContent;
import com.jaspersoft.studio.utils.UIUtil;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Date;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.ui.validator.EmptyStringValidator;
import net.sf.jasperreports.eclipse.ui.validator.IDStringValidator;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ResourcePageContent
extends APageContent {
    private Text tname;
    private Text tid;
    private Text tudate;
    private Proxy proxy;
    private Text tparent;
    private Text tdesc;
    private Text tcdate;
    private Text ttype;
    private Button bisRef;

    public ResourcePageContent(ANode parent, AMResource resource, DataBindingContext bindingContext) {
        super(parent, resource, bindingContext);
    }

    public ResourcePageContent(ANode parent, AMResource resource) {
        super(parent, resource);
    }

    @Override
    public String getPageName() {
        return "com.jaspersoft.studio.server.page.resource";
    }

    @Override
    public String getName() {
        return Messages.AResourcePage_title;
    }

    @Override
    public Control createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        UIUtil.createLabel((Composite)composite, (String)Messages.AResourcePage_parentfolder);
        this.tparent = new Text(composite, 2056);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.tparent.setLayoutData((Object)gd);
        UIUtil.createLabel((Composite)composite, (String)Messages.AResourcePage_type);
        this.ttype = new Text(composite, 2056);
        this.ttype.setLayoutData((Object)new GridData(768));
        this.bisRef = new Button(composite, 32);
        this.bisRef.setText(Messages.ResourcePageContent_isReference);
        this.bisRef.setEnabled(false);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.bisRef.setLayoutData((Object)gd);
        UIUtil.createLabel((Composite)composite, (String)Messages.AResourcePage_creationdate);
        this.tcdate = new Text(composite, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.tcdate.setLayoutData((Object)gd);
        ResourceDescriptor rd = this.res.getValue();
        this.proxy = new Proxy(rd);
        if (this.res.isSupported(Feature.UPDATEDATE)) {
            UIUtil.createLabel((Composite)composite, (String)Messages.ResourcePageContent_UpdateDate);
            this.tudate = new Text(composite, 2056);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            this.tudate.setLayoutData((Object)gd);
        }
        UIUtil.createSeparator((Composite)composite, (int)4);
        UIUtil.createLabel((Composite)composite, (String)Messages.AResourcePage_name);
        this.tname = new Text(composite, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.widthHint = 500;
        this.tname.setLayoutData((Object)gd);
        UIUtil.createLabel((Composite)composite, (String)Messages.AResourcePage_id);
        this.tid = new Text(composite, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.widthHint = 500;
        this.tid.setLayoutData((Object)gd);
        UIUtil.createLabel((Composite)composite, (String)Messages.AResourcePage_description);
        this.tdesc = new Text(composite, 2114);
        gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 500;
        gd.horizontalSpan = 3;
        this.tdesc.setLayoutData((Object)gd);
        this.tid.setEditable(rd.getIsNew());
        if (rd.getIsNew()) {
            rd.setName(rd.getLabel());
            this.tname.addModifyListener(e -> this.tid.setText(IDStringValidator.safeChar((String)Misc.nvl((String)this.tname.getText()))));
            this.tid.addModifyListener(e -> {
                if (this.refresh) {
                    return;
                }
                this.refresh = true;
                String validationError = this.validateID(this.tid.getText());
                this.page.setErrorMessage(validationError);
                this.setPageComplete(validationError == null);
                this.refresh = false;
            });
            this.tid.addVerifyListener(e -> {
                String string = e.text = IDStringValidator.safeChar((String)e.text);
            });
        }
        this.rebind();
        this.tname.setFocus();
        return composite;
    }

    private String validateID(String t) {
        String validationError = ValidationUtils.validateName(t);
        if (validationError == null) {
            for (INode n1 : this.pnode.getChildren()) {
                if (!(n1 instanceof AMResource) || n1 == this.res || ((AMResource)n1).getValue().getName() == null || !((AMResource)n1).getValue().getName().equals(t)) continue;
                return "This id is already used in this folder";
            }
        }
        return validationError;
    }

    @Override
    protected void rebind() {
        ResourceDescriptor rd = this.res.getValue();
        if (this.tudate != null) {
            this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)0).observe((Widget)this.tudate), PojoProperties.value((String)"updateDate").observe((Object)this.proxy));
        }
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)0).observe((Widget)this.tparent), PojoProperties.value((String)"parentFolder").observe((Object)this.proxy));
        IConnection c = this.res.getWsClient();
        final Format f = c != null ? c.getTimestampFormat() : DateFormat.getTimeInstance();
        Converter t2mConv = new Converter(String.class, Date.class){

            public Object convert(Object fromObject) {
                try {
                    if (fromObject instanceof String && !((String)fromObject).isEmpty()) {
                        return f.parseObject((String)fromObject);
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        Converter m2tConv = new Converter(Date.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject == null) {
                    return "";
                }
                return f.format(fromObject);
            }
        };
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)0).observe((Widget)this.tcdate), PojoProperties.value((String)"creationDate").observe((Object)rd), new UpdateValueStrategy().setConverter((IConverter)t2mConv), new UpdateValueStrategy().setConverter((IConverter)m2tConv));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)0).observe((Widget)this.ttype), PojoProperties.value((String)"wsType").observe((Object)rd));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)this.bisRef), PojoProperties.value((String)"isReference").observe((Object)rd));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tid), PojoProperties.value((String)"name").observe((Object)rd), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new IDValidator()), null);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tname), PojoProperties.value((String)"label").observe((Object)rd), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new EmptyStringValidator()), null);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tdesc), PojoProperties.value((String)"description").observe((Object)rd));
        this.bindingContext.updateTargets();
        IConnection con = this.getWsClient();
        if (!rd.getIsNew() && !con.isSupported(Feature.SEARCHREPOSITORY) && this.res instanceof MAdHocDataView) {
            this.ttype.setEnabled(false);
            if (this.tname != null) {
                this.tname.setEnabled(false);
            }
            if (this.tdesc != null) {
                this.tdesc.setEnabled(false);
            }
            UIUtils.getDisplay().asyncExec(() -> {
                this.setPageComplete(false);
                this.page.setDescription(Messages.ResourcePageContent_3);
            });
        }
    }

    @Override
    public String getHelpContext() {
        return "com.jaspersoft.studio.doc.editResource";
    }

    @Override
    public boolean isPageComplete() {
        if (this.tid.getText().trim().isEmpty() || this.tname.getText().trim().isEmpty()) {
            return false;
        }
        return super.isPageComplete();
    }

    class IDValidator
    implements IValidator<String> {
        private IDStringValidator validator = new IDStringValidator();

        IDValidator() {
        }

        public IStatus validate(String value) {
            String err;
            IStatus status = this.validator.validate(value);
            if (status.equals(Status.OK_STATUS) && (err = ResourcePageContent.this.validateID(value)) != null) {
                status = ValidationStatus.error((String)err);
            }
            return status;
        }
    }

    class Proxy {
        private ResourceDescriptor rd;

        public Proxy(ResourceDescriptor rd) {
            this.rd = rd;
        }

        public ResourceDescriptor getResourceDescriptor() {
            return this.rd;
        }

        public String getUpdateDate() {
            return DiffFields.getSoapValue(this.rd, "updateDate");
        }

        public void setUpdateDate(String name) {
        }

        public String getParentFolder() {
            String p = this.rd.getParentFolder();
            if (Misc.isNullOrEmpty((String)p)) {
                p = "/";
            }
            return p;
        }

        public void setParentFolder(String p) {
            this.rd.setParentFolder(p);
        }
    }
}

