/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page.datasource;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceProperty;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import com.jaspersoft.studio.property.dataset.TLabelProvider;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.datasource.filter.DatasourceVDSFilter;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.utils.ResourceDescriptorUtil;
import com.jaspersoft.studio.server.wizard.resource.APageContent;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorDatasource;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.MoveT2TButtons;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DatasourceVDSPageContent
extends APageContent {
    protected List<Object> inFields;
    protected List<Object> outFields;
    protected Table rightTable;
    protected TableViewer rightTView;
    protected TreeViewer leftTView;
    private MoveT2TButtons mt2t = null;
    private ListOrderButtons lob = null;
    private List<ResourceDescriptor> oldvds = new ArrayList<ResourceDescriptor>();

    public DatasourceVDSPageContent(ANode parent, AMResource resource, DataBindingContext bindingContext) {
        super(parent, resource, bindingContext);
    }

    public DatasourceVDSPageContent(ANode parent, AMResource resource) {
        super(parent, resource);
    }

    @Override
    public String getPageName() {
        return "com.jaspersoft.studio.server.page.datasource.vds";
    }

    @Override
    public String getName() {
        return Messages.RDDatasourceVDSPage_title;
    }

    @Override
    public Control createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.leftTView = new TreeViewer(composite, 2050);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 400;
        this.leftTView.getTree().setLayoutData((Object)gd);
        this.leftTView.setContentProvider((IContentProvider)new ReportTreeContetProvider());
        this.leftTView.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.leftTView);
        this.leftTView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.leftTView.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        this.rightTable = new Table(composite, 68098);
        gd = new GridData(1808);
        gd.minimumWidth = 400;
        this.rightTable.setLayoutData((Object)gd);
        this.rightTable.setHeaderVisible(true);
        this.rightTView = new TableViewer(this.rightTable);
        this.rightTView.setContentProvider((IContentProvider)new ListContentProvider());
        this.setLabelProvider(this.rightTView);
        this.createColumns();
        this.createOrderButtons(composite);
        this.fillRightTable();
        this.mt2t = new MoveT2TButtons(){

            protected void handleMove(ColumnViewer leftTView, ColumnViewer rightTView) {
                StructuredSelection s = (StructuredSelection)leftTView.getSelection();
                if (!s.isEmpty()) {
                    Object input = leftTView.getInput();
                    if (input instanceof MServerProfile) {
                        MServerProfile cfr_ignored_0 = (MServerProfile)((Object)leftTView.getInput());
                        List right = (List)rightTView.getInput();
                        Object[] objectArray = s.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object obj = objectArray[n2];
                            AMResource mres = (AMResource)((Object)obj);
                            ResourceDescriptor rd = mres.getValue();
                            if (SelectorDatasource.isDatasource(rd) && !this.checkExists(right, rd)) {
                                ResourceDescriptor rdc = null;
                                for (ResourceDescriptor r : DatasourceVDSPageContent.this.oldvds) {
                                    if (!r.getReferenceUri().equals(rd.getUriString())) continue;
                                    rdc = r;
                                    break;
                                }
                                if (rdc == null) {
                                    rdc = new ResourceDescriptor();
                                    rdc.setName(rd.getName());
                                    rdc.setLabel(rdc.getLabel());
                                    rdc.setIsReference(true);
                                    rdc.setReferenceUri(rd.getUriString());
                                    rdc.setWsType("datasource");
                                    rdc.setIsNew(true);
                                    rdc.setResourceProperty("PROP_DATASOURCE_SUB_DS_ID", rd.getName());
                                }
                                right.add(new Proxy(rdc));
                                DatasourceVDSPageContent.this.res.getValue().getChildren().add(rdc);
                            }
                            ++n2;
                        }
                    } else {
                        List left = (List)leftTView.getInput();
                        Object[] objectArray = s.toArray();
                        int n = objectArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Object obj = objectArray[n3];
                            left.remove(obj);
                            DatasourceVDSPageContent.this.res.getValue().getChildren().remove(((Proxy)obj).getResourceDescriptor());
                            ++n3;
                        }
                    }
                    leftTView.refresh();
                    rightTView.refresh();
                    this.fireChangeEvent();
                }
            }

            protected boolean checkExists(List<Proxy> right, ResourceDescriptor rd) {
                boolean exists = false;
                for (Proxy p : right) {
                    if (!p.getRefuri().equals(rd.getUriString())) continue;
                    exists = true;
                    break;
                }
                return exists;
            }
        };
        this.mt2t.createButtonsShort(bGroup, (ColumnViewer)this.leftTView, this.rightTView, false);
        this.fillLeftTable();
        this.rebind();
        return composite;
    }

    @Override
    protected void rebind() {
    }

    private void fillLeftTable() {
        final MServerProfile root = ServerManager.getMServerProfileCopy((MServerProfile)this.pnode.getRoot());
        try {
            this.page.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        WSClientHelper.getDatasourceListTree(monitor, root, new DatasourceVDSFilter());
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!(this).DatasourceVDSPageContent.this.leftTView.getControl().isDisposed()) {
                                    (this).DatasourceVDSPageContent.this.leftTView.setInput((Object)root);
                                    (this).DatasourceVDSPageContent.this.leftTView.refresh();
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        UIUtils.showError((Throwable)e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e);
            this.leftTView.setInput((Object)root);
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e);
            this.leftTView.setInput((Object)root);
        }
    }

    private void fillRightTable() {
        ResourceDescriptor rd = this.res.getValue();
        ArrayList<Proxy> input = new ArrayList<Proxy>();
        List<ResourceDescriptor> children = rd.getChildren();
        for (ResourceDescriptor c : children) {
            if (!SelectorDatasource.isDatasource(c)) continue;
            input.add(new Proxy(c));
            this.oldvds.add(c);
        }
        this.rightTView.setInput(input);
    }

    protected void setLabelProvider(TableViewer tableViewer) {
        tableViewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
    }

    protected void createColumns() {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.rightTView, (int)2);
        TableColumn[] col = new TableColumn[2];
        TableViewerColumn viewerColumn = new TableViewerColumn(this.rightTView, 0);
        col[0] = viewerColumn.getColumn();
        col[0].setText(Messages.RDDatasourceVDSPage_dsname);
        col[0].pack();
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Proxy p = (Proxy)element;
                return p.getName();
            }

            public String getToolTipText(Object element) {
                Proxy p = (Proxy)element;
                return p.getRefuri();
            }
        });
        viewerColumn = new TableViewerColumn(this.rightTView, 0);
        col[1] = viewerColumn.getColumn();
        col[1].setText(Messages.RDDatasourceVDSPage_dsalias);
        col[1].pack();
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Proxy p = (Proxy)element;
                return p.getAlias();
            }

            public String getToolTipText(Object element) {
                Proxy p = (Proxy)element;
                return p.getRefuri();
            }
        });
        viewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.rightTView){

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)DatasourceVDSPageContent.this.rightTView.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                Proxy p = (Proxy)element;
                return p.getAlias();
            }

            protected void setValue(Object element, Object value) {
                Proxy p = (Proxy)element;
                p.setAlias((String)value);
                DatasourceVDSPageContent.this.rightTView.refresh(element);
            }
        });
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, false));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, false));
        this.rightTable.setLayout((Layout)tlayout);
    }

    private void createOrderButtons(Composite composite) {
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        this.lob = new ListOrderButtons();
        this.lob.createOrderButtons(bGroup, this.rightTView);
    }

    @Override
    public String getHelpContext() {
        return "com.jaspersoft.studio.doc.editVirtualDatasource";
    }

    class Proxy {
        private String refuri;
        private String name;
        private ResourceProperty alias;
        private ResourceDescriptor rd;

        public Proxy(ResourceDescriptor rd) {
            this.rd = rd;
            if (rd.getIsReference()) {
                this.refuri = rd.getReferenceUri();
                this.name = this.refuri.substring(this.refuri.lastIndexOf("/") + 1);
            } else {
                this.name = rd.getName();
            }
            this.alias = ResourceDescriptorUtil.getProperty("PROP_DATASOURCE_SUB_DS_ID", rd.getProperties());
        }

        public ResourceDescriptor getResourceDescriptor() {
            return this.rd;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias.getValue();
        }

        public void setAlias(String name) {
            this.alias.setValue(name);
        }

        public String getRefuri() {
            return this.refuri != null ? this.refuri : this.name;
        }
    }
}

