/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page.selector;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.properties.dialog.RepositoryDialog;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.utils.IPageCompleteListener;
import com.jaspersoft.studio.server.wizard.find.FindResourceJob;
import com.jaspersoft.studio.server.wizard.resource.ResourceWizard;
import com.jaspersoft.studio.utils.inputhistory.InputHistoryCache;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class ASelector {
    protected Button brRepo;
    protected Text jsRefDS;
    protected Button brLocal;
    protected Text jsLocDS;
    protected Button bLoc;
    protected Button bRef;
    protected AMResource res;
    protected ResourceDescriptor resRD;
    protected ANode parent;
    protected boolean valid = true;
    private boolean refresh = false;
    private List<IPageCompleteListener> listeners = new ArrayList<IPageCompleteListener>();

    public Control createControls(Composite cmp, ANode parent, AMResource res) {
        this.res = res;
        this.parent = parent;
        if (res != null) {
            this.resRD = res.getValue();
        }
        Composite composite = new Composite(cmp, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createRepository(composite);
        this.createLocal(composite);
        this.init();
        return composite;
    }

    protected void createRepository(Composite prnt) {
        this.brRepo = new Button(prnt, 16);
        this.brRepo.setText(Messages.SelectorQuery_selectfromrepository);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.brRepo.setLayoutData((Object)gd);
        this.brRepo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASelector.this.setEnabled(0);
            }
        });
        this.jsRefDS = new Text(prnt, 2048);
        this.jsRefDS.setLayoutData((Object)new GridData(768));
        this.jsRefDS.addModifyListener(e -> {
            if (!this.refresh) {
                final String uri = this.jsRefDS.getText().trim();
                Job job = new Job("Validating"){
                    private ResourceDescriptor newrd;

                    protected IStatus run(IProgressMonitor monitor) {
                        IStatus status;
                        block5: {
                            status = Status.OK_STATUS;
                            try {
                                try {
                                    ResourceDescriptor rd = ASelector.this.createLocal((AMResource)null);
                                    rd.setUriString(uri);
                                    this.newrd = WSClientHelper.getResource(monitor, ASelector.this.res.getWsClient(), rd, null);
                                    ASelector.this.valid = this.newrd != null && ASelector.this.isResCompatible(ResourceFactory.getResource(null, this.newrd, -1));
                                }
                                catch (Exception e) {
                                    ASelector.this.valid = false;
                                    e.printStackTrace();
                                    monitor.done();
                                    break block5;
                                }
                            }
                            catch (Throwable throwable) {
                                monitor.done();
                                throw throwable;
                            }
                            monitor.done();
                        }
                        UIUtils.getDisplay().asyncExec(() -> {
                            if (ASelector.this.valid) {
                                ASelector.this.setRemoteResource(this.newrd, (ANode)ASelector.this.res, false);
                            }
                            ASelector.this.firePageComplete();
                        });
                        return status;
                    }
                };
                job.setPriority(20);
                job.setSystem(false);
                job.setUser(true);
                job.schedule();
            }
        });
        InputHistoryCache.bindText((Text)this.jsRefDS, (String)this.getClass().getName());
        this.bRef = new Button(prnt, 8);
        this.bRef.setText("...");
        this.bRef.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MServerProfile msp = ServerManager.getMServerProfileCopy((MServerProfile)ASelector.this.parent.getRoot());
                if (msp.isSupported(Feature.SEARCHREPOSITORY)) {
                    ResourceDescriptor rd = FindResourceJob.doFindResource(msp, ASelector.this.getIncludeTypes(), ASelector.this.getExcludeTypes());
                    if (rd != null) {
                        ASelector.this.setRemoteResource(rd, ASelector.this.parent, true);
                    }
                } else {
                    RepositoryDialog rd = new RepositoryDialog(ASelector.this.bRef.getShell(), (INode)msp){

                        @Override
                        public boolean isResourceCompatible(AMResource r) {
                            return ASelector.this.isResCompatible(r);
                        }
                    };
                    if (rd.open() == 0) {
                        AMResource rs = rd.getResource();
                        if (rs != null) {
                            ASelector.this.setRemoteResource(rs.getValue(), ASelector.this.parent, true);
                        }
                        ASelector.this.valid = true;
                    }
                }
            }
        });
    }

    private void setRemoteResource(ResourceDescriptor rd, ANode pnode, boolean modifyText) {
        ResourceDescriptor runit = this.resRD;
        try {
            rd = WSClientHelper.getResource((IProgressMonitor)new NullProgressMonitor(), pnode, rd);
            if (runit.getWsType().equals("reportUnit")) {
                rd.setIsReference(true);
                rd.setReferenceUri(rd.getUriString());
                rd.setParentFolder(String.valueOf(runit.getParentFolder()) + "/" + runit.getName() + "_files");
                rd.setUriString(String.valueOf(rd.getParentFolder()) + "/" + rd.getName());
                this.setupResource(rd);
                this.replaceChildren(rd);
                if (modifyText) {
                    this.jsRefDS.setText(rd.getReferenceUri());
                }
            } else {
                this.setupResource(rd);
                this.replaceChildren(rd);
                if (modifyText) {
                    this.jsRefDS.setText(rd.getUriString());
                }
            }
        }
        catch (Exception e1) {
            UIUtils.showError((Throwable)e1);
        }
        this.firePageComplete();
    }

    public void resetResource() {
        this.replaceChildren(null);
        this.setEnabled(ASelector.isReference(this.resRD) ? 0 : 1);
    }

    protected void replaceChildren(ResourceDescriptor rd) {
        int index;
        ResourceDescriptor rdel = this.getResourceDescriptor(this.resRD);
        List<ResourceDescriptor> children = this.resRD.getChildren();
        if (rdel != null && (index = children.indexOf(rdel)) >= 0) {
            children.remove(index);
        }
        if (rd != null) {
            children.add(rd);
        }
    }

    protected abstract String[] getIncludeTypes();

    protected abstract String[] getExcludeTypes();

    protected abstract boolean isResCompatible(AMResource var1);

    protected void createLocal(Composite prnt) {
        this.brLocal = new Button(prnt, 16);
        this.brLocal.setText(Messages.SelectorQuery_localresource);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.brLocal.setLayoutData((Object)gd);
        this.brLocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASelector.this.setEnabled(1);
            }
        });
        this.jsLocDS = new Text(prnt, 2056);
        this.jsLocDS.setLayoutData((Object)new GridData(768));
        this.bLoc = new Button(prnt, 8);
        this.bLoc.setText("...");
        this.bLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceDescriptor runit = ASelector.this.resRD;
                ResourceDescriptor ref = ASelector.this.getResourceDescriptor(runit);
                if (ASelector.isReference(ref)) {
                    ref = null;
                }
                AMResource r = null;
                if (ref != null) {
                    r = ResourceFactory.getResource(null, ref = ASelector.cloneResource(ref), -1);
                    if (!ASelector.this.showLocalWizard(r, ASelector.this.parent)) {
                        return;
                    }
                } else {
                    r = ASelector.this.getLocalResource(ASelector.this.res, runit, ASelector.this.parent);
                    if (r != null) {
                        ref = r.getValue();
                    }
                }
                if (r == null) {
                    return;
                }
                ref.setUriString(String.valueOf(ref.getParentFolder()) + "/" + ref.getName());
                ASelector.this.replaceChildren(ref);
                ASelector.this.jsLocDS.setText(Misc.nvl((String)ref.getName()));
                ASelector.this.firePageComplete();
            }
        });
    }

    protected AMResource getLocalResource(AMResource res, ResourceDescriptor runit, ANode pnode) {
        ResourceDescriptor ref = this.createLocal(res);
        ref.setIsNew(true);
        ref.setIsReference(false);
        ref.setParentFolder(String.valueOf(runit.getParentFolder()) + "/" + runit.getName() + "_files");
        this.setupResource(ref);
        ref.setDirty(true);
        AMResource r = ResourceFactory.getResource(null, ref, -1);
        if (!this.showLocalWizard(r, pnode)) {
            return null;
        }
        return r;
    }

    protected boolean showLocalWizard(AMResource r, ANode pnode) {
        ResourceWizard wizard = new ResourceWizard(pnode, r, true, true);
        WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
        dialog.create();
        return dialog.open() == 0;
    }

    protected void setupResource(ResourceDescriptor rd) {
    }

    public static boolean isReference(ResourceDescriptor ref) {
        return ref != null && (ref.getIsReference() || ref.getWsType().equals("reference"));
    }

    protected abstract ResourceDescriptor createLocal(AMResource var1);

    protected void init() {
        this.setEnabled(ASelector.isReference(this.getResourceDescriptor(this.resRD)) ? 0 : 1);
    }

    public boolean isPageComplete() {
        boolean val;
        boolean bl = val = this.getResourceDescriptor(this.resRD) != null;
        if (val && this.brRepo.getSelection()) {
            return this.valid;
        }
        return val;
    }

    public void firePageComplete() {
        boolean completed = this.isPageComplete();
        for (IPageCompleteListener l : this.listeners) {
            l.pageCompleted(completed);
        }
    }

    public void addPageCompleteListener(IPageCompleteListener listener) {
        this.listeners.add(listener);
    }

    public void removePageCompleteListener(IPageCompleteListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract ResourceDescriptor getResourceDescriptor(ResourceDescriptor var1);

    protected void setEnabled(int pos) {
        if (this.refresh) {
            return;
        }
        this.refresh = true;
        this.bRef.setEnabled(false);
        this.jsRefDS.setEnabled(false);
        this.bLoc.setEnabled(false);
        this.jsLocDS.setEnabled(false);
        this.brRepo.setSelection(false);
        this.brLocal.setSelection(false);
        this.jsRefDS.setText("");
        this.jsLocDS.setText("");
        ResourceDescriptor r = this.getResourceDescriptor(this.resRD);
        switch (pos) {
            case 0: {
                this.bRef.setEnabled(true);
                this.brRepo.setSelection(true);
                this.jsRefDS.setEnabled(true);
                if (!ASelector.isReference(r)) break;
                this.jsRefDS.setText(Misc.nvl((String)r.getReferenceUri()));
                break;
            }
            case 1: {
                this.brLocal.setSelection(true);
                this.bLoc.setEnabled(true);
                if (r == null || r.getIsReference() || r.getWsType().equals("reference")) break;
                this.jsLocDS.setText(Misc.nvl((String)r.getName()));
            }
        }
        this.refresh = false;
    }

    public static void copyFields(ResourceDescriptor rd, ResourceDescriptor rnew) {
        rnew.setParameters(rd.getParameters());
        rnew.setProperties(rd.getProperties());
        rnew.setChildren(rd.getChildren());
        rnew.setQueryData(rd.getQueryData());
        rnew.setQueryValueColumn(rd.getQueryValueColumn());
        rnew.setQueryVisibleColumns(rd.getQueryVisibleColumns());
        rnew.setListOfValues(rd.getListOfValues());
        rnew.setPattern(rd.getPattern());
        rnew.setMinValue(rd.getMinValue());
        rnew.setMaxValue(rd.getMaxValue());
        rnew.setStrictMin(rd.isStrictMin());
        rnew.setStrictMax(rd.isStrictMax());
        rnew.setDataType(rd.getDataType());
        rnew.setJndiName(rd.getJndiName());
        rnew.setBeanMethod(rd.getBeanMethod());
        rnew.setBeanName(rd.getBeanName());
        rnew.setDriverClass(rd.getDriverClass());
        rnew.setUsername(rd.getUsername());
        rnew.setPassword(rd.getPassword());
        rnew.setConnectionUrl(rd.getConnectionUrl());
        rnew.setName(rd.getName());
        rnew.setLabel(rd.getLabel());
        rnew.setDescription(rd.getDescription());
        rnew.setFile(rd.getFile());
        rnew.setData(rd.getData());
        rnew.setHasData(rd.getHasData());
        rnew.setSql(rd.getSql());
    }

    public static ResourceDescriptor cloneResource(ResourceDescriptor rd) {
        ResourceDescriptor rnew = new ResourceDescriptor();
        ASelector.copyFields(rd, rnew);
        rnew.setIsNew(rd.getIsNew());
        rnew.setIsReference(rd.getIsReference());
        rnew.setUriString(rd.getUriString());
        rnew.setParentFolder(rd.getParentFolder());
        rnew.setDataSourceType(rd.getDataSourceType());
        rnew.setWsType(rd.getWsType());
        return rnew;
    }

    protected ResourceDescriptor checkReference(ResourceDescriptor r) {
        if (r.getWsType().equals("reference")) {
            try {
                return WSClientHelper.getReference((IProgressMonitor)new NullProgressMonitor(), (ANode)this.res, r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

