/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page.selector;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MJrxml;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.preferences.JRSPreferencesPage;
import com.jaspersoft.studio.server.properties.dialog.RepositoryDialog;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.wizard.find.FindResourceJob;
import java.io.File;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class SelectorJrxml {
    private Button brRepo;
    private Text jsRefDS;
    private Button brLocal;
    private Text jsLocDS;
    private Button bLoc;
    private Button bRef;
    private AMResource res;
    private SelectionListener listener;
    private ResourceDescriptor rlocal;
    private ResourceDescriptor rrepo;
    private File resfile;

    public void createControls(Composite cmp, final ANode parent, final AMResource res) {
        this.res = res;
        Composite composite = new Composite(cmp, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.brRepo = new Button(composite, 16);
        this.brRepo.setText("Select from Repository");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.brRepo.setLayoutData((Object)gd);
        this.brRepo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectorJrxml.this.brRepo.getSelection()) {
                    SelectorJrxml.this.setEnabled(0, false);
                }
            }
        });
        this.jsRefDS = new Text(composite, 2048);
        this.jsRefDS.setLayoutData((Object)new GridData(768));
        this.jsRefDS.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectorJrxml.this.fireSelectionChanged();
            }
        });
        this.bRef = new Button(composite, 8);
        this.bRef.setText("Browse");
        this.bRef.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MServerProfile msp = ServerManager.getMServerProfileCopy((MServerProfile)parent.getRoot());
                if (res.isSupported(Feature.SEARCHREPOSITORY)) {
                    boolean sv = msp.getWsClient().getServerInfo().getVersion().compareTo("5.5") >= 0;
                    ResourceDescriptor rd = FindResourceJob.doFindResource(msp, new String[]{sv ? ClientFile.FileType.jrxml.name() : "file"}, null);
                    if (rd != null) {
                        SelectorJrxml.this.setRemoteResource(res, rd, parent);
                    }
                } else {
                    AMResource rs;
                    RepositoryDialog rd = new RepositoryDialog(UIUtils.getShell(), (INode)msp){

                        @Override
                        public boolean isResourceCompatible(AMResource r) {
                            return r instanceof MJrxml;
                        }
                    };
                    if (rd.open() == 0 && (rs = rd.getResource()) != null) {
                        SelectorJrxml.this.setRemoteResource(res, rs.getValue(), parent);
                    }
                }
            }
        });
        this.brLocal = new Button(composite, 16);
        this.brLocal.setText("Local Resource");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.brLocal.setLayoutData((Object)gd);
        this.brLocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectorJrxml.this.brLocal.getSelection()) {
                    SelectorJrxml.this.setEnabled(1, false);
                }
            }
        });
        this.jsLocDS = new Text(composite, 2048);
        this.jsLocDS.setLayoutData((Object)new GridData(768));
        this.jsLocDS.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectorJrxml.this.fireSelectionChanged();
            }
        });
        this.bLoc = new Button(composite, 8);
        this.bLoc.setText("Browse");
        this.bLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredResourcesSelectionDialog wizard = new FilteredResourcesSelectionDialog(UIUtils.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                wizard.setInitialPattern("*.jrxml");
                if (wizard.open() == 0) {
                    ResourceDescriptor jrxmlDescriptor = new ResourceDescriptor();
                    jrxmlDescriptor.setName(JRSPreferencesPage.getDefaultMainReportName(res.getJasperConfiguration()));
                    jrxmlDescriptor.setLabel(JRSPreferencesPage.getDefaultMainReportLabel(res.getJasperConfiguration()));
                    jrxmlDescriptor.setWsType("jrxml");
                    jrxmlDescriptor.setIsNew(true);
                    jrxmlDescriptor.setMainReport(true);
                    jrxmlDescriptor.setIsReference(false);
                    jrxmlDescriptor.setHasData(true);
                    SelectorJrxml.replaceMainReport(res, jrxmlDescriptor);
                    SelectorJrxml.this.fireSelectionChanged();
                    SelectorJrxml.this.resfile = new File(((IFile)wizard.getFirstResult()).getLocationURI());
                    ((AFileResource)res).setFile(SelectorJrxml.this.resfile);
                    SelectorJrxml.this.jsLocDS.setText(SelectorJrxml.this.resfile.getAbsolutePath());
                }
            }
        });
        ResourceDescriptor r = SelectorJrxml.getMainReport(res.getValue());
        if (r != null) {
            if (r.getIsReference()) {
                this.rrepo = r;
                this.setEnabled(0, true);
            } else {
                this.rlocal = r;
                this.setEnabled(1, true);
            }
        } else {
            this.setEnabled(1, true);
        }
    }

    private void setRemoteResource(AMResource res, ResourceDescriptor rd, ANode parent) {
        ResourceDescriptor runit = res.getValue();
        try {
            rd = WSClientHelper.getResource((IProgressMonitor)new NullProgressMonitor(), parent, rd);
            rd.setIsReference(true);
            rd.setMainReport(true);
            rd.setReferenceUri(rd.getUriString());
            rd.setParentFolder(String.valueOf(runit.getParentFolder()) + "/" + runit.getName() + "_files");
            rd.setWsType("jrxml");
            rd.setUriString(String.valueOf(rd.getParentFolder()) + "/" + rd.getName());
            SelectorJrxml.replaceMainReport(res, rd);
            rd.setDirty(false);
            this.fireSelectionChanged();
            this.jsRefDS.setText(rd.getUriString());
        }
        catch (Exception e1) {
            UIUtils.showError((Throwable)e1);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listener = listener;
    }

    public static void replaceMainReport(AMResource res, ResourceDescriptor rd) {
        int index;
        ResourceDescriptor rdel = SelectorJrxml.getMainReport(res.getValue());
        if (rdel != null && (index = res.getValue().getChildren().indexOf(rdel)) >= 0) {
            res.getValue().getChildren().remove(index);
        }
        if (rd != null) {
            res.getValue().getChildren().add(rd);
        }
    }

    public static ResourceDescriptor getMainReport(ResourceDescriptor ru) {
        for (ResourceDescriptor obj : ru.getChildren()) {
            ResourceDescriptor r = obj;
            if (!r.getWsType().equals("jrxml") || !r.isMainReport()) continue;
            return r;
        }
        return null;
    }

    private void setEnabled(int pos, boolean init) {
        this.bRef.setEnabled(false);
        this.jsRefDS.setEnabled(false);
        this.bLoc.setEnabled(false);
        this.jsLocDS.setEnabled(false);
        this.brRepo.setSelection(false);
        this.brLocal.setSelection(false);
        this.jsRefDS.setText("");
        this.jsLocDS.setText("");
        ResourceDescriptor r = SelectorJrxml.getMainReport(this.res.getValue());
        AFileResource aFileResource = (AFileResource)this.res;
        File file = aFileResource.getFile();
        switch (pos) {
            case 0: {
                if (!init) {
                    this.rlocal = r;
                    this.resfile = file;
                    SelectorJrxml.replaceMainReport(this.res, this.rrepo);
                    aFileResource.setFile(null);
                }
                this.bRef.setEnabled(true);
                this.brRepo.setSelection(true);
                this.jsRefDS.setEnabled(true);
                if (this.rrepo == null) break;
                this.jsRefDS.setText(Misc.nvl((String)this.rrepo.getReferenceUri()));
                break;
            }
            case 1: {
                if (!init) {
                    this.rrepo = r;
                    SelectorJrxml.replaceMainReport(this.res, this.rlocal);
                }
                this.brLocal.setSelection(true);
                this.bLoc.setEnabled(true);
                this.jsLocDS.setEnabled(true);
                if (this.rlocal == null) break;
                if (this.resfile != null) {
                    this.jsLocDS.setText(this.resfile.getAbsolutePath());
                    aFileResource.setFile(this.resfile);
                    break;
                }
                this.jsLocDS.setText(Misc.nvl((String)this.rlocal.getName()));
            }
        }
    }

    private void fireSelectionChanged() {
        if (this.listener != null) {
            this.listener.widgetSelected(null);
        }
    }

    public boolean isJrxmlSelected() {
        return !this.jsRefDS.getText().trim().isEmpty() || !this.jsLocDS.getText().trim().isEmpty();
    }
}

