/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.sf.jasperreports.eclipse.MScopedPreferenceStore;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.util.BundleCommonUtils;
import net.sf.jasperreports.eclipse.util.ResourceScope;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public abstract class AbstractJRUIPlugin
extends AbstractUIPlugin {
    private final boolean TRACE_ENABLED = "true".equalsIgnoreCase(Platform.getDebugOption((String)(String.valueOf(this.getPluginID()) + "/debug")));
    private SynchronousBundleListener bundleListener = event -> {
        if (event.getBundle() == this.getBundle() && event.getType() == 2 && this.getBundle().getState() == 32) {
            this.postStartOperations();
        }
    };
    private Map<String, ImageDescriptor> map = new HashMap<String, ImageDescriptor>();
    private Map<IResource, Map<String, MScopedPreferenceStore>> prefStores = new HashMap<IResource, Map<String, MScopedPreferenceStore>>();
    private MScopedPreferenceStore instStore;
    private Set<ScopedPreferenceStore> pstores = new CopyOnWriteArraySet<ScopedPreferenceStore>();
    private Set<IPropertyChangeListener> listeners = new CopyOnWriteArraySet<IPropertyChangeListener>();

    public abstract String getPluginID();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        context.addBundleListener((BundleListener)this.bundleListener);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.bundleListener != null) {
                context.removeBundleListener((BundleListener)this.bundleListener);
            }
        }
        finally {
            super.stop(context);
        }
    }

    protected void postStartOperations() {
    }

    public String getFileLocation(String path) throws IOException {
        return BundleCommonUtils.getFileLocation(this.getPluginID(), path);
    }

    public ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor id = this.map.get(path);
        if (id == null) {
            id = BundleCommonUtils.getImageDescriptor(this.getPluginID(), path);
        }
        return id;
    }

    public Image getImage(String path) {
        return BundleCommonUtils.getImage(this.getImageDescriptor(path));
    }

    public Image getImage(ImageDescriptor descriptor) {
        return BundleCommonUtils.getImage(descriptor);
    }

    public void logError(String message, Throwable exception) {
        BundleCommonUtils.logError(this.getPluginID(), message, exception);
    }

    public void logError(Throwable exception) {
        Assert.isNotNull((Object)exception);
        this.logError(Messages.AbstractJRUIPlugin_GenericErrorMsg, exception);
    }

    public void logWarning(String message, Throwable exception) {
        BundleCommonUtils.logWarning(this.getPluginID(), message, exception);
    }

    public void logWarning(String message) {
        this.logWarning(message, null);
    }

    public void logInfo(String message) {
        BundleCommonUtils.logInfo(this.getPluginID(), message);
    }

    public boolean isTraceEnabled() {
        return this.TRACE_ENABLED;
    }

    public void logTrace(String message) {
        if (this.TRACE_ENABLED) {
            BundleCommonUtils.logTrace(this.getPluginID(), message);
        }
    }

    public void logTrace(Throwable e) {
        if (this.TRACE_ENABLED) {
            BundleCommonUtils.logTrace(this.getPluginID(), e);
        }
    }

    public void log(IStatus status) {
        BundleCommonUtils.logStatus(this.getPluginID(), status);
    }

    public IPreferenceStore getPreferenceStore() {
        return this.getPreferenceStore(null, this.getPluginID());
    }

    public ScopedPreferenceStore getPreferenceStore(IResource project, String pageId) {
        MScopedPreferenceStore pstore = null;
        if (project != null) {
            Map<String, MScopedPreferenceStore> pagemap = this.prefStores.get(project);
            if (pagemap != null) {
                pstore = pagemap.get(pageId);
            } else {
                pagemap = new HashMap<String, MScopedPreferenceStore>();
                this.prefStores.put(project, pagemap);
            }
            if (pstore == null) {
                if (project instanceof IProject) {
                    pstore = new MScopedPreferenceStore((IScopeContext)new ProjectScope((IProject)project), pageId);
                    pstore.setSearchContexts(new IScopeContext[]{new ProjectScope((IProject)project), InstanceScope.INSTANCE});
                } else {
                    pstore = new MScopedPreferenceStore(new ResourceScope(project), pageId);
                    pstore.setSearchContexts(new IScopeContext[]{new ResourceScope(project), new ProjectScope(project.getProject()), InstanceScope.INSTANCE});
                }
                for (IPropertyChangeListener pl : this.listeners) {
                    pstore.addPropertyChangeListener(pl);
                }
                this.pstores.add(pstore);
                pagemap.put(pageId, pstore);
            }
        } else {
            if (this.instStore == null) {
                this.instStore = new MScopedPreferenceStore(InstanceScope.INSTANCE, pageId);
                this.instStore.setSearchContexts(new IScopeContext[]{InstanceScope.INSTANCE});
                this.pstores.add(this.instStore);
                for (IPropertyChangeListener pl : this.listeners) {
                    this.instStore.addPropertyChangeListener(pl);
                }
            }
            pstore = this.instStore;
        }
        return pstore;
    }

    public void addPreferenceListener(IPropertyChangeListener plistener, IResource r) {
        if (!this.listeners.contains(plistener)) {
            this.listeners.add(plistener);
            this.getPreferenceStore().addPropertyChangeListener(plistener);
            if (r != null) {
                String id = this.getPluginID();
                this.getPreferenceStore(r, id).addPropertyChangeListener(plistener);
                if (r instanceof IFile) {
                    this.getPreferenceStore((IResource)r.getProject(), id).addPropertyChangeListener(plistener);
                }
            }
        }
    }

    public void removePreferenceListener(IPropertyChangeListener plistener) {
        if (plistener == null) {
            return;
        }
        this.getPreferenceStore().removePropertyChangeListener(plistener);
        for (ScopedPreferenceStore p : this.pstores) {
            p.removePropertyChangeListener(plistener);
        }
        this.listeners.remove(plistener);
    }
}

