/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.AbstractJRUIPlugin;
import net.sf.jasperreports.eclipse.IKeyboardEvent;
import net.sf.jasperreports.eclipse.classpath.container.ClasspathContainerManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;
import org.osgi.framework.BundleContext;

public class JasperReportsPlugin
extends AbstractJRUIPlugin {
    private static JasperReportsPlugin plugin;
    public static final String PLUGIN_ID = "net.sf.jasperreports";
    private static ClasspathContainerManager classpathContainerManager;
    private static List<IKeyboardEvent> events;
    private static HashSet<Integer> pressedKeys;
    private static HashMap<Integer, Point> mousePressLocation;
    private static Listener keyDownListener;
    private static Listener keyUpListener;
    private static Listener focusLostListener;
    private static Listener mousePressListener;

    static {
        events = new ArrayList<IKeyboardEvent>();
        pressedKeys = new HashSet();
        mousePressLocation = new HashMap();
        keyDownListener = null;
        keyUpListener = null;
        focusLostListener = null;
        mousePressListener = null;
    }

    public JasperReportsPlugin() {
        plugin = this;
    }

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public static void initializeKeyListener() {
        if (keyDownListener == null && keyUpListener == null && focusLostListener == null && mousePressListener == null) {
            keyDownListener = new Listener(){

                public void handleEvent(Event e) {
                    pressedKeys.add(e.keyCode);
                    JasperReportsPlugin.fireEvent(true, e.keyCode);
                }
            };
            keyUpListener = new Listener(){

                public void handleEvent(Event e) {
                    pressedKeys.remove(e.keyCode);
                    JasperReportsPlugin.fireEvent(false, e.keyCode);
                }
            };
            focusLostListener = new Listener(){

                public void handleEvent(Event event) {
                    pressedKeys.clear();
                    JasperReportsPlugin.fireEvent(false, -1);
                }
            };
            mousePressListener = new Listener(){

                public void handleEvent(Event event) {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    Point point = display.getCursorLocation();
                    mousePressLocation.put(event.button, point);
                }
            };
            PlatformUI.getWorkbench().getDisplay().addFilter(1, keyDownListener);
            PlatformUI.getWorkbench().getDisplay().addFilter(2, keyUpListener);
            PlatformUI.getWorkbench().getDisplay().addFilter(16, focusLostListener);
            PlatformUI.getWorkbench().getDisplay().addFilter(3, mousePressListener);
        }
    }

    public static boolean isPressed(int keyCode) {
        return pressedKeys.contains(keyCode);
    }

    public static int getPressedKeysNumber() {
        return pressedKeys.size();
    }

    public static Integer[] getPressedKeys() {
        return pressedKeys.toArray(new Integer[pressedKeys.size()]);
    }

    public static Point getLastClickLocation(int mouseButton) {
        return mousePressLocation.get(mouseButton);
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        events.clear();
        if (keyDownListener != null && keyUpListener != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            PlatformUI.getWorkbench().getDisplay().removeFilter(1, keyDownListener);
            PlatformUI.getWorkbench().getDisplay().removeFilter(2, keyUpListener);
            PlatformUI.getWorkbench().getDisplay().removeFilter(16, focusLostListener);
            PlatformUI.getWorkbench().getDisplay().removeFilter(3, mousePressListener);
        }
        ResourceManager.dispose();
    }

    public static void addKeyListener(IKeyboardEvent event) {
        if (event != null && !events.contains(event)) {
            events.add(event);
        }
    }

    public static boolean removeKeyListener(IKeyboardEvent event) {
        return events.remove(event);
    }

    protected static void fireEvent(boolean isKeyDown, int keycode) {
        if (isKeyDown) {
            for (IKeyboardEvent event : events) {
                event.keyDown(keycode);
            }
        } else {
            for (IKeyboardEvent event : events) {
                event.keyUp(keycode);
            }
        }
    }

    public static JasperReportsPlugin getDefault() {
        return plugin;
    }

    @Override
    public String getPluginID() {
        return PLUGIN_ID;
    }

    public static ClasspathContainerManager getClasspathContainerManager() {
        if (classpathContainerManager == null) {
            classpathContainerManager = new ClasspathContainerManager();
            classpathContainerManager.init();
        }
        return classpathContainerManager;
    }
}

