/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.builder;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.classpath.container.JRClasspathContainer;
import net.sf.jasperreports.eclipse.classpath.container.JRDependenciesClasspathContainer;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleExecuter {
    private static final String CONSOLE_NAME = "JRConsole Console";
    private String[] command;
    private IFile fileToCompile;
    private String jrFolder;
    private static IWorkbenchPage page;
    private static final HashSet<String> classpathExclusionSet;
    private Job readOutputJob = new Job("Compiling job"){

        protected IStatus run(IProgressMonitor monitor) {
            block9: {
                MessageConsole console = ConsoleExecuter.this.getCleanConsole();
                MessageConsoleStream outputStream = console.newMessageStream();
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    try {
                        if (ConsoleExecuter.this.fileToCompile.exists()) {
                            monitor.beginTask("Compiling " + ConsoleExecuter.this.fileToCompile.getName(), -1);
                            File projectFolder = ConsoleExecuter.this.fileToCompile.getParent().getLocation().toFile();
                            Process process = Runtime.getRuntime().exec(ConsoleExecuter.this.command, null, projectFolder);
                            outputStream.println(Messages.ConsoleExecuter_startCompilation);
                            String fullCommand = "";
                            String[] stringArray = ConsoleExecuter.this.command;
                            int n = ConsoleExecuter.this.command.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String str = stringArray[n2];
                                fullCommand = String.valueOf(fullCommand) + str + " ";
                                ++n2;
                            }
                            outputStream.println(fullCommand);
                            new PrintOutput(process.getInputStream(), outputStream).run();
                            new PrintOutput(process.getErrorStream(), outputStream).run();
                            process.waitFor();
                            outputStream.println(Messages.ConsoleExecuter_endCompilation);
                            ConsoleExecuter.this.fileToCompile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                            IResource r = ConsoleExecuter.this.fileToCompile.getParent().findMember(ConsoleExecuter.this.fileToCompile.getName().replaceAll("\\.jrxml$", ".jasper"));
                            if (r != null) {
                                r.setDerived(true, monitor);
                            }
                            monitor.done();
                            break block9;
                        }
                        outputStream.println(Messages.ConsoleExecuter_fileNotFound);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        outputStream.println(ex.getMessage());
                        FileUtils.closeStream((Closeable)outputStream);
                    }
                }
                finally {
                    FileUtils.closeStream((Closeable)outputStream);
                }
            }
            return Status.OK_STATUS;
        }
    };

    static {
        classpathExclusionSet = new HashSet();
        classpathExclusionSet.clear();
        classpathExclusionSet.add(JRClasspathContainer.ID.toString());
        classpathExclusionSet.add(JRDependenciesClasspathContainer.ID.toString());
    }

    private static void initPage() {
        if (page == null) {
            UIUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow != null) {
                        page = activeWorkbenchWindow.getActivePage();
                    }
                }
            });
        }
    }

    private String getOutputFilename(IFile fileToCompile) {
        String fileName = fileToCompile.getName();
        if (fileName.endsWith(".jrxml")) {
            return fileName.substring(0, fileName.length() - 6).concat(".jasper");
        }
        return fileName.concat(".jasper");
    }

    protected String getJavaCommand() {
        return "java";
    }

    private IProject getProject(IFile fileToCompile) {
        return fileToCompile.getProject();
    }

    private List<String> getClasspaths(IProject project) {
        IJavaProject jprj = JavaCore.create((IProject)project);
        ArrayList<String> classpath = new ArrayList<String>();
        IWorkspaceRoot wsRoot = project.getWorkspace().getRoot();
        if (jprj != null) {
            try {
                IClasspathEntry[] entries = jprj.getRawClasspath();
                IPath defaultLocationPath = jprj.getOutputLocation();
                if (defaultLocationPath != null) {
                    IFolder entryOutputFolder = wsRoot.getFolder(defaultLocationPath);
                    classpath.add(String.valueOf(entryOutputFolder.getLocation().toOSString()) + File.separator);
                }
                IClasspathEntry[] iClasspathEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry en = iClasspathEntryArray[n2];
                    if (en.getEntryKind() == 5) {
                        String containerPath = en.getPath().toString();
                        if (!containerPath.startsWith(JavaRuntime.JRE_CONTAINER) && !classpathExclusionSet.contains(containerPath)) {
                            this.addEntries(JavaCore.getClasspathContainer((IPath)en.getPath(), (IJavaProject)jprj).getClasspathEntries(), classpath, jprj);
                        }
                    } else if (en.getEntryKind() == 2) {
                        classpath.add(String.valueOf(wsRoot.findMember(en.getPath()).getLocation().toOSString()) + File.separator);
                    } else if (en.getEntryKind() == 3 && en.getContentKind() == 1) {
                        IPath entryOutputLocation = en.getOutputLocation();
                        if (entryOutputLocation != null) {
                            IFolder entryOutputFolder = wsRoot.getFolder(entryOutputLocation);
                            classpath.add(String.valueOf(entryOutputFolder.getLocation().toOSString()) + File.separator);
                        }
                    } else {
                        IPath location = wsRoot.getFile(en.getPath()).getLocation();
                        if (location == null) {
                            classpath.add(en.getPath().toOSString());
                        } else {
                            classpath.add(location.toOSString());
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return classpath;
    }

    private void addEntries(IClasspathEntry[] entries, List<String> classpath, IJavaProject jprj) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry en = iClasspathEntryArray[n2];
            if (en.getEntryKind() == 5) {
                try {
                    this.addEntries(JavaCore.getClasspathContainer((IPath)en.getPath(), (IJavaProject)jprj).getClasspathEntries(), classpath, jprj);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (en.getEntryKind() == 2 || en.getEntryKind() == 3) {
                classpath.add(String.valueOf(workspace.getRoot().findMember(en.getPath()).getLocation().toOSString()) + File.separator + "*");
            } else {
                classpath.add(en.getPath().toOSString());
            }
            ++n2;
        }
    }

    private String getClasspath(IFile fileToCompile) {
        String classPath = String.valueOf(this.jrFolder) + File.separator + "*";
        IProject project = this.getProject(fileToCompile);
        if (project != null) {
            String separator = ";";
            if (Util.isMac() || Util.isLinux()) {
                separator = ":";
            }
            for (String entry : this.getClasspaths(project)) {
                classPath = String.valueOf(classPath) + separator + entry;
            }
        }
        return classPath;
    }

    public ConsoleExecuter(IFile fileToCompile, String jrFolder, String destFolder) {
        ConsoleExecuter.initPage();
        this.fileToCompile = fileToCompile;
        this.jrFolder = jrFolder;
        this.configure(destFolder);
    }

    private void configure(String destFolder) {
        ArrayList<String> commandSegments = new ArrayList<String>();
        commandSegments.add(this.getJavaCommand());
        commandSegments.add("-cp");
        commandSegments.add(this.getClasspath(this.fileToCompile));
        commandSegments.add("com.jaspersoft.jasperreports.toolkit.JRCompiler");
        commandSegments.add(this.fileToCompile.getLocation().toOSString());
        String destinationPath = destFolder;
        if (destinationPath != null) {
            File destination = new File(destinationPath);
            destination.mkdirs();
            if (!destinationPath.endsWith(File.separator)) {
                destinationPath = String.valueOf(destinationPath) + File.separator;
            }
            String fileName = this.getOutputFilename(this.fileToCompile);
            File checkExistence = new File(destinationPath = String.valueOf(destinationPath) + fileName);
            if (checkExistence.exists()) {
                checkExistence.delete();
            }
            commandSegments.add(destinationPath);
        } else {
            String filename = this.getOutputFilename(this.fileToCompile);
            if (filename != null) {
                try {
                    IResource[] iResourceArray = this.fileToCompile.getParent().members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource res = iResourceArray[n2];
                        if (res.getName().equals(filename)) {
                            res.delete(true, (IProgressMonitor)new NullProgressMonitor());
                            this.fileToCompile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                        }
                        ++n2;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.command = commandSegments.toArray(new String[commandSegments.size()]);
    }

    public void runCompilation() {
        this.readOutputJob.setPriority(20);
        this.readOutputJob.schedule();
    }

    private MessageConsole getCleanConsole() {
        final MessageConsole myConsole = ConsoleExecuter.findConsole(CONSOLE_NAME);
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    String id = "org.eclipse.ui.console.ConsoleView";
                    IConsoleView view = (IConsoleView)page.showView(id);
                    view.display((IConsole)myConsole);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        myConsole.clearConsole();
        return myConsole;
    }

    public static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    protected class PrintOutput
    extends Thread {
        private InputStream is = null;
        private MessageConsoleStream out;

        public PrintOutput(InputStream is, MessageConsoleStream out) {
            this.is = is;
            this.out = out;
        }

        @Override
        public void run() {
            String s = null;
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
                while ((s = br.readLine()) != null) {
                    this.out.println(s);
                }
            }
            catch (IOException e) {
                e.printStackTrace(new PrintStream((OutputStream)this.out));
            }
        }
    }
}

