/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.builder;

public class JRDefinition
implements Comparable<JRDefinition> {
    private String resourceURL;
    private String version;

    public JRDefinition() {
    }

    public JRDefinition(String resourceURL, String version) {
        this.resourceURL = resourceURL;
        this.version = version;
    }

    public void setResourceURL(String resourceURL) {
        this.resourceURL = resourceURL;
    }

    public String getResourceURL() {
        return this.resourceURL;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public int compareTo(JRDefinition o) {
        if (o.getVersion() == null) {
            return 1;
        }
        String[] thisParts = this.version.split("\\.");
        String[] thatParts = o.getVersion().split("\\.");
        int length = Math.max(thisParts.length, thatParts.length);
        int i = 0;
        while (i < length) {
            int thatPart;
            int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
            int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart > thatPart) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public Object clone() {
        return new JRDefinition(this.resourceURL, this.version);
    }
}

