/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.builder;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import net.sf.jasperreports.eclipse.IDisposeListener;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.MScopedPreferenceStore;
import net.sf.jasperreports.eclipse.classpath.JavaProjectClassLoader;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.query.EmptyQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.util.CompositeClassloader;
import net.sf.jasperreports.engine.util.MessageProviderFactory;
import net.sf.jasperreports.engine.util.ResourceBundleMessageProviderFactory;
import net.sf.jasperreports.functions.FunctionsBundle;
import net.sf.jasperreports.repo.DefaultRepositoryService;
import net.sf.jasperreports.repo.RepositoryService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.Preferences;

public class JSSReportContext
extends SimpleJasperReportsContext {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private ClasspathListener classpathlistener;
    private PreferenceListener preferenceListener;
    private String qualifier = "com.jaspersoft.studio";
    private boolean refreshMessageProviderFactory = true;
    private boolean refreshFunctionsBundles = true;
    private JavaProjectClassLoader javaclassloader;
    private List<FunctionsBundle> functionsBundles;
    private MessageProviderFactory messageProviderFactory;
    protected MScopedPreferenceStore pstore;
    private List<IDisposeListener> toDispose;
    private ClassLoader classLoader;
    private boolean isPropsCached = false;
    public static final String PROPERTY_JRPROPERTY_PREFIX = "ireport.jrproperty.";
    private List<JRQueryExecuterFactoryBundle> qExecutors;
    private static Map<IResource, JSSReportContext> contexts = new HashMap<IResource, JSSReportContext>();
    private static IResourceChangeListener resListener = new ResourceChangeReporter();
    private static JSSReportContext instance;

    protected void handlePrefChanged(PropertyChangeEvent event) {
    }

    protected void handleClasspathChanged(java.beans.PropertyChangeEvent event) {
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public JSSReportContext(JasperReportsContext parent, IResource res) {
        super(parent);
        this.init(res);
    }

    public ScopedPreferenceStore getPrefStore() {
        return this.pstore;
    }

    public void init(IResource r) {
        IFile oldFile = (IFile)this.get("ifile");
        if (r instanceof IFile) {
            if (oldFile != null && oldFile == r) {
                return;
            }
            this.initRepositoryService((IFile)r);
        } else if (oldFile != null) {
            this.remove("ifile");
            this.initRepositoryService(null);
        }
        IProject oldPrj = (IProject)this.get("iproject");
        if (oldFile == null && r instanceof IProject && oldPrj != null && oldPrj == r) {
            return;
        }
        this.pstore = (MScopedPreferenceStore)JasperReportsPlugin.getDefault().getPreferenceStore(r, this.qualifier);
        IProject project = null;
        if (r instanceof IProject) {
            project = (IProject)r;
        }
        if (r instanceof IFile) {
            this.put("ifile", r);
            project = r.getProject();
        }
        this.isPropsCached = false;
        this.qExecutors = null;
        if (this.preferenceListener == null) {
            this.preferenceListener = new PreferenceListener();
            JasperReportsPlugin.getDefault().addPreferenceListener(this.preferenceListener, r);
        }
        if (project == oldPrj && oldPrj != null) {
            return;
        }
        if (project != null) {
            this.put("iproject", project);
        } else {
            this.remove("iproject");
        }
        this.initClassloader(project);
        this.refreshMessageProviderFactory = true;
        this.refreshFunctionsBundles = true;
        this.functionsBundles = null;
        this.messageProviderFactory = null;
        this.handleClasspathChanged(null);
    }

    protected void initClassloader(IProject project) {
        if (this.javaclassloader != null && this.classpathlistener != null) {
            this.javaclassloader.removeClasspathListener(this.classpathlistener);
            this.remove("javaProjectClassLoader");
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (project != null && project.getNature("org.eclipse.jdt.core.javanature") != null) {
                this.javaclassloader = JavaProjectClassLoader.instance(JavaCore.create((IProject)project), cl);
                this.put("javaProjectClassLoader", this.javaclassloader);
                this.classpathlistener = new ClasspathListener();
                this.javaclassloader.addClasspathListener(this.classpathlistener);
                cl = this.javaclassloader;
            }
            cl = this.insertClassLoader(cl);
            cl = new CompositeClassloader(cl, ((Object)((Object)this)).getClass().getClassLoader()){

                protected URL findResource(String name) {
                    if (name.endsWith("GroovyEvaluator.groovy")) {
                        return null;
                    }
                    return super.findResource(name);
                }

                protected Class<?> findClass(String className) throws ClassNotFoundException {
                    if (className.endsWith("GroovyEvaluator")) {
                        throw new ClassNotFoundException(className);
                    }
                    return super.findClass(className);
                }
            };
            this.setClassLoader(cl);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected ClassLoader insertClassLoader(ClassLoader cl) {
        return cl;
    }

    protected void initRepositoryService(IFile r) {
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        List<RepositoryService> rs = this.getExtensions(RepositoryService.class);
        for (RepositoryService r : rs) {
            if (!(r instanceof DefaultRepositoryService)) continue;
            ((DefaultRepositoryService)r).setClassLoader(classLoader);
        }
        this.put("CURRENT_CLASS_LOADER", classLoader);
    }

    public void dispose() {
        JasperReportsPlugin.getDefault().removePreferenceListener(this.preferenceListener);
        if (this.javaclassloader != null) {
            this.javaclassloader.removeClasspathListener(this.classpathlistener);
        }
        for (PropertyChangeListener l : Arrays.asList(this.propertyChangeSupport.getPropertyChangeListeners())) {
            this.propertyChangeSupport.removePropertyChangeListener(l);
        }
        if (this.toDispose != null) {
            for (IDisposeListener d : this.toDispose) {
                d.dispose();
            }
        }
    }

    public void addDisposeListener(IDisposeListener listener) {
        if (this.toDispose == null) {
            this.toDispose = new ArrayList<IDisposeListener>();
        }
        this.toDispose.add(listener);
    }

    public void removeDisposeListener(IDisposeListener listener) {
        if (this.toDispose == null) {
            return;
        }
        this.toDispose.remove(listener);
    }

    public void put(String key, Object value) {
        this.setValue(key, value);
    }

    public Object get(String key) {
        return this.getValue(key);
    }

    public void remove(String key) {
        this.removeValue(key);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public <T> T get(String key, T def) {
        Object value = this.get(key);
        if (value != null && def != null && value.getClass().isAssignableFrom(def.getClass())) {
            return (T)value;
        }
        return def;
    }

    public Map<String, String> getProperties() {
        String val;
        if (this.isPropsCached) {
            return this.getPropertiesMap();
        }
        this.setPropertiesMap(null);
        Map smap = super.getProperties();
        HashMap<String, String> propmap = new HashMap<String, String>();
        if (smap != null && !smap.isEmpty()) {
            propmap.putAll(smap);
        }
        this.setPropertiesMap(propmap);
        Properties props = this.getJRProperties();
        for (Object key : props.keySet()) {
            if (!(key instanceof String) || (val = props.getProperty((String)key)) == null) continue;
            propmap.put((String)key, val);
        }
        this.isPropsCached = true;
        this.pstore.setWithDefault(false);
        for (Object key : propmap.keySet()) {
            val = Misc.nullIfEmpty(this.pstore.getString((String)key));
            if (val == null) continue;
            propmap.put((String)key, val);
        }
        this.pstore.setWithDefault(true);
        return propmap;
    }

    private Properties getJRProperties() {
        Properties props = null;
        try {
            try {
                this.pstore.setWithDefault(false);
                props = FileUtils.load(this.pstore.getString("net.sf.jasperreports.JRPROPERTIES"));
            }
            catch (IOException e) {
                e.printStackTrace();
                props = new Properties();
                this.pstore.setWithDefault(true);
            }
        }
        finally {
            this.pstore.setWithDefault(true);
        }
        return props;
    }

    public String getProperty(String key) {
        this.pstore.setWithDefault(false);
        String val = Platform.getPreferencesService().get(key, null, (Preferences[])this.pstore.getPreferenceNodes(true));
        this.pstore.setWithDefault(true);
        if (val != null) {
            return val;
        }
        return super.getProperty(key);
    }

    public String getPropertyDef(String key, String def) {
        String p = this.getProperty(key);
        if (p == null) {
            p = this.pstore.getDefaultString(key);
        }
        if (p == null) {
            p = def;
        }
        return p;
    }

    public String getProperty(String key, String def) {
        String p = this.getProperty(key);
        if (p == null) {
            return def;
        }
        return p;
    }

    public Character getPropertyCharacterDef(String key, Character def) {
        String v;
        Character p = this.getPropertyCharacter(key);
        if (p == null && (v = this.pstore.getDefaultString(key)) != null && !v.isEmpty()) {
            return Character.valueOf(v.charAt(0));
        }
        if (p == null) {
            p = def;
        }
        return p;
    }

    public Character getPropertyCharacter(String key, Character def) {
        Character p = this.getPropertyCharacter(key);
        if (p == null) {
            p = def;
        }
        return p;
    }

    public Character getPropertyCharacter(String key) {
        String p = this.getProperty(key);
        if (p != null && !p.isEmpty()) {
            return Character.valueOf(p.charAt(0));
        }
        return null;
    }

    public Boolean getPropertyBoolean(String key) {
        String p = this.getProperty(key);
        if (p != null) {
            return Boolean.parseBoolean(p);
        }
        return null;
    }

    public Boolean getPropertyBoolean(String key, boolean def) {
        Boolean p = this.getPropertyBoolean(key);
        if (p == null) {
            return def;
        }
        return p;
    }

    public Boolean getPropertyBooleanDef(String key, boolean def) {
        Boolean p = this.getPropertyBoolean(key);
        if (p == null) {
            p = def;
        }
        return p;
    }

    public Integer getPropertyInteger(String key) {
        String p = this.getProperty(key);
        if (p != null) {
            return Integer.valueOf(p);
        }
        return null;
    }

    public Integer getPropertyInteger(String key, int def) {
        Integer p = this.getPropertyInteger(key);
        if (p == null) {
            return def;
        }
        return p;
    }

    public Integer getPropertyIntegerDef(String key, int def) {
        Integer p = this.getPropertyInteger(key);
        if (p == null) {
            p = def;
        }
        return p;
    }

    public Long getPropertyLong(String key) {
        String p = this.getProperty(key);
        if (p != null) {
            return Long.valueOf(p);
        }
        return null;
    }

    public Long getPropertyIntegerDef(String key, long def) {
        Long p = this.getPropertyLong(key);
        if (p == null) {
            p = def;
        }
        return p;
    }

    public Float getPropertyFloat(String key) {
        String p = this.getProperty(key);
        if (p != null) {
            return Float.valueOf(p);
        }
        return null;
    }

    public Double getPropertyDouble(String key) {
        String p = this.getProperty(key);
        if (p != null) {
            return Double.valueOf(p);
        }
        return null;
    }

    public Double getPropertyDoubleDef(String key, double def) {
        Double p = this.getPropertyDouble(key);
        if (p == null) {
            p = def;
        }
        return p;
    }

    public Float getPropertyFloat(String key, float def) {
        Float p = this.getPropertyFloat(key);
        if (p == null) {
            return Float.valueOf(def);
        }
        return p;
    }

    public Float getPropertyFloatDef(String key, float def) {
        Float p = this.getPropertyFloat(key);
        if (p == null) {
            p = Float.valueOf(def);
        }
        return p;
    }

    private List<FunctionsBundle> getExtensionFunctions() {
        if (this.functionsBundles == null || this.refreshFunctionsBundles) {
            ResourceBundle.clearCache(this.getClassLoader());
            this.functionsBundles = super.getExtensions(FunctionsBundle.class);
            LinkedHashSet<FunctionsBundle> fBundlesSet = new LinkedHashSet<FunctionsBundle>(this.functionsBundles);
            this.functionsBundles = new ArrayList<FunctionsBundle>(fBundlesSet);
            this.refreshFunctionsBundles = false;
        }
        return this.functionsBundles;
    }

    public <T> List<T> getExtensions(Class<T> extensionType) {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        List<Object> result = null;
        try {
            if (this.classLoader != null) {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            if (extensionType == FunctionsBundle.class) {
                result = this.getExtensionFunctions();
            } else if (extensionType == MessageProviderFactory.class) {
                if (this.messageProviderFactory == null || this.refreshMessageProviderFactory) {
                    this.messageProviderFactory = new ResourceBundleMessageProviderFactory(this.getClassLoader());
                    this.refreshFunctionsBundles = false;
                }
                result = Collections.singletonList(this.messageProviderFactory);
            } else if (extensionType == JRQueryExecuterFactoryBundle.class) {
                try {
                    if (this.qExecutors == null) {
                        this.qExecutors = new ArrayList<JRQueryExecuterFactoryBundle>();
                        this.qExecutors.add(EmptyQueryExecuterFactoryBundle.getInstance((JasperReportsContext)this));
                    }
                    result = this.qExecutors;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } else {
                result = this.getExtensionsByType(extensionType);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        return result;
    }

    protected <T> List<T> getExtensionsByType(Class<T> extensionType) {
        List result = null;
        try {
            result = super.getExtensions(extensionType);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    public static JSSReportContext getNewConfig() {
        return JSSReportContext.getNewConfig(null);
    }

    public static JSSReportContext getNewConfig(IResource f) {
        return new JSSReportContext((JasperReportsContext)DefaultJasperReportsContext.getInstance(), f);
    }

    public static JSSReportContext getDefaultInstance(IResource f) {
        JSSReportContext c = contexts.get(f);
        if (c != null) {
            return c;
        }
        c = JSSReportContext.getNewConfig(f);
        contexts.put(f, c);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(resListener, 6);
        return c;
    }

    public static JSSReportContext getDefaultInstance() {
        if (instance == null) {
            instance = JSSReportContext.getNewConfig();
        }
        return instance;
    }

    public void refreshClasspath() {
        this.classpathlistener.propertyChange(null);
    }

    private class ClasspathListener
    implements PropertyChangeListener {
        private ClasspathListener() {
        }

        @Override
        public void propertyChange(java.beans.PropertyChangeEvent event) {
            event.getNewValue();
            JSSReportContext.this.refreshMessageProviderFactory = true;
            JSSReportContext.this.refreshFunctionsBundles = true;
            JSSReportContext.this.functionsBundles = null;
            JSSReportContext.this.qExecutors = null;
            JSSReportContext.this.messageProviderFactory = null;
            JSSReportContext.this.handleClasspathChanged(event);
            JSSReportContext.this.propertyChangeSupport.firePropertyChange(new java.beans.PropertyChangeEvent(this, "classpath", null, event));
        }
    }

    private final class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("net.sf.jasperreports.JRPROPERTIES")) {
                JSSReportContext.this.isPropsCached = false;
                JSSReportContext.this.getProperties();
                JSSReportContext.this.qExecutors = null;
            } else if (property.startsWith("com.jaspersoft.studio.")) {
                JSSReportContext.this.isPropsCached = false;
                JSSReportContext.this.getProperties();
            }
            JSSReportContext.this.handlePrefChanged(event);
            JSSReportContext.this.propertyChangeSupport.firePropertyChange(new java.beans.PropertyChangeEvent(this, "preferences", null, event));
        }
    }

    private static class ResourceChangeReporter
    implements IResourceChangeListener {
        private ResourceChangeReporter() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResource res = event.getResource();
            JSSReportContext c = contexts.get(res);
            if (c != null) {
                c.dispose();
                contexts.remove((Object)c);
            }
        }
    }
}

