/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.builder.action;

import java.util.ArrayList;
import java.util.Set;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.classpath.container.JRClasspathContainer;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleNatureAction
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                this.changeProjectSettings(project);
            }
        }
    }

    public void changeProjectSettings(final IProject project) {
        if (project != null) {
            Job job = new Job(Messages.ToggleNatureAction_JobName){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            ToggleNatureAction.this.toggleNature(project, monitor);
                        }
                        catch (Exception e) {
                            UIUtils.showError(e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        ISelection s = targetPart.getSite().getSelectionProvider().getSelection();
        if (s instanceof TreeSelection) {
            TreePath[] tp = ((TreeSelection)s).getPaths();
            int i = 0;
            while (i < tp.length) {
                block6: {
                    Object obj = tp[i].getFirstSegment();
                    if (obj instanceof IProject) {
                        try {
                            if (((IProject)obj).hasNature("net.sf.jasperreports.nature")) {
                                action.setChecked(true);
                                break block6;
                            }
                            action.setChecked(false);
                            break;
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void toggleNature(IProject project, IProgressMonitor monitor) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            int i = 0;
            while (i < natures.length) {
                if ("net.sf.jasperreports.nature".equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    project.setDescription(description, monitor);
                    ArrayList<IClasspathEntry> centries = new ArrayList<IClasspathEntry>();
                    IClasspathEntry[] entries = javaProject.readRawClasspath();
                    Set<Path> set = JasperReportsPlugin.getClasspathContainerManager().getRemovableContainers();
                    IClasspathEntry[] iClasspathEntryArray = entries;
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry en = iClasspathEntryArray[n2];
                        if (!en.getPath().equals((Object)JRClasspathContainer.ID) && !set.contains(en.getPath())) {
                            centries.add(en);
                        }
                        ++n2;
                    }
                    javaProject.setRawClasspath(centries.toArray(new IClasspathEntry[centries.size()]), monitor);
                    return;
                }
                ++i;
            }
            ProjectUtil.addNature(project, "net.sf.jasperreports.nature", monitor);
            ProjectUtil.createJRClasspathContainer(monitor, javaProject);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

