/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.builder.jdt;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.jasperreports.eclipse.builder.jdt.CompilationUnit;
import net.sf.jasperreports.eclipse.builder.jdt.CompilationUnitResult;
import net.sf.jasperreports.eclipse.builder.jdt.NameEnvironement;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRClassGenerator;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRJavacCompiler;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.functions.FunctionsUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class JRJdtCompiler
extends JRAbstractJavaCompiler {
    private static final String JDT_PROPERTIES_PREFIX = "org.eclipse.jdt.core.";
    private static final IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
    public static final Log log = LogFactory.getLog(JRJdtCompiler.class);
    private final ClassLoader classLoader = this.getClassLoader();
    private Map<String, String> settings;

    public JRJdtCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext, false);
    }

    public JRJdtCompiler() {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance());
    }

    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) {
        INameEnvironment env = this.getNameEnvironment(units);
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        CompilerRequestor requestor = this.getCompilerRequestor(units);
        Compiler compiler = new Compiler(env, policy, this.getJdtSettings(), (ICompilerRequestor)requestor, (IProblemFactory)problemFactory);
        do {
            ICompilationUnit[] compilationUnits = requestor.processCompilationUnits();
            compiler.compile(compilationUnits);
        } while (requestor.hasMissingMethods());
        requestor.processProblems();
        return requestor.getFormattedProblems();
    }

    protected INameEnvironment getNameEnvironment(JRCompilationUnit[] units) {
        return new NameEnvironement(this, units);
    }

    protected CompilerRequestor getCompilerRequestor(JRCompilationUnit[] units) {
        return new CompilerRequestor(this.jasperReportsContext, this, units);
    }

    protected Map<String, String> getJdtSettings() {
        if (this.settings == null) {
            this.settings = new HashMap<String, String>();
            this.settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
            this.settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
            this.settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
            List properties = JRPropertiesUtil.getInstance((JasperReportsContext)this.jasperReportsContext).getProperties(JDT_PROPERTIES_PREFIX);
            for (JRPropertiesUtil.PropertySuffix property : properties) {
                String propVal = property.getValue();
                if (propVal == null || propVal.length() <= 0) continue;
                this.settings.put(property.getKey(), propVal);
            }
            Properties systemProps = System.getProperties();
            Enumeration<?> it = systemProps.propertyNames();
            while (it.hasMoreElements()) {
                String propVal;
                String propName = (String)it.nextElement();
                if (!propName.startsWith(JDT_PROPERTIES_PREFIX) || (propVal = systemProps.getProperty(propName)) == null || propVal.length() <= 0) continue;
                this.settings.put(propName, propVal);
            }
        }
        return this.settings;
    }

    private ClassLoader getClassLoader() {
        ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
        if (clsLoader != null) {
            try {
                Class.forName(JRJdtCompiler.class.getName(), true, clsLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clsLoader = null;
            }
        }
        if (clsLoader == null) {
            clsLoader = JRClassLoader.class.getClassLoader();
        }
        return clsLoader;
    }

    protected InputStream getResource(String resourceName) {
        return this.classLoader.getResourceAsStream(resourceName);
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    protected void checkLanguage(String language) throws JRException {
        if (!"java".equals(language)) {
            throw new JRException("Language \"" + language + "\" not supported by this report compiler.\n" + "Expecting \"java\" instead.");
        }
    }

    protected JRCompilationUnit recreateCompileUnit(JRCompilationUnit compilationUnit, Set<Method> missingMethods) {
        String unitName = compilationUnit.getName();
        JRSourceCompileTask sourceTask = compilationUnit.getCompileTask();
        JRCompilationSourceCode sourceCode = JRClassGenerator.modifySource((JRSourceCompileTask)sourceTask, missingMethods, (String)compilationUnit.getSourceCode());
        File sourceFile = compilationUnit.getSourceFile();
        File saveSourceDir = sourceFile == null ? null : sourceFile.getParentFile();
        sourceFile = this.getSourceFile(saveSourceDir, compilationUnit.getCompileName(), sourceCode);
        JRCompilationUnit newUnit = new JRCompilationUnit(unitName);
        newUnit.setDirectEvaluations(compilationUnit.getDirectEvaluations());
        newUnit.setSource(sourceCode, sourceFile, sourceTask);
        return newUnit;
    }

    protected JRCompilationSourceCode generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return JRClassGenerator.generateClass((JRSourceCompileTask)sourceTask);
    }

    protected String getSourceFileName(String unitName) {
        return String.valueOf(unitName) + ".java";
    }

    protected String getCompilerClass() {
        return JRJavacCompiler.class.getName();
    }

    public static class CompilerRequestor
    implements ICompilerRequestor {
        private final JasperReportsContext jasperReportsContext;
        protected final JRJdtCompiler compiler;
        protected final JRCompilationUnit[] units;
        protected final CompilationUnitResult[] unitResults;

        public CompilerRequestor(JasperReportsContext jasperReportsContext, JRJdtCompiler compiler, JRCompilationUnit[] units) {
            this.jasperReportsContext = jasperReportsContext;
            this.compiler = compiler;
            this.units = units;
            this.unitResults = new CompilationUnitResult[units.length];
            this.reset();
        }

        public void acceptResult(CompilationResult result) {
            String className = ((CompilationUnit)result.getCompilationUnit()).className;
            int classIdx = 0;
            while (classIdx < this.units.length) {
                if (className.equals(this.units[classIdx].getCompileName())) break;
                ++classIdx;
            }
            if (result.hasErrors()) {
                IProblem[] problems = this.getJavaCompilationErrors(result);
                this.unitResults[classIdx].problems = problems;
                String sourceCode = this.units[classIdx].getSourceCode();
                int i = 0;
                while (i < problems.length) {
                    IProblem problem = problems[i];
                    if (0x4000064 == problem.getID() && problem.getSourceStart() >= 0 && problem.getSourceEnd() >= 0) {
                        String methodName = sourceCode.substring(problem.getSourceStart(), problem.getSourceEnd() + 1);
                        Method method = FunctionsUtil.getInstance((JasperReportsContext)this.jasperReportsContext).getMethod4Function(methodName);
                        if (method != null) {
                            this.unitResults[classIdx].addMissingMethod(method);
                        }
                    }
                    ++i;
                }
            } else {
                ClassFile[] resultClassFiles = result.getClassFiles();
                int i = 0;
                while (i < resultClassFiles.length) {
                    this.units[classIdx].setCompileData((Serializable)resultClassFiles[i].getBytes());
                    ++i;
                }
            }
        }

        public void processProblems() {
        }

        public String getFormattedProblems() {
            StringBuffer problemBuffer = new StringBuffer();
            int u = 0;
            while (u < this.units.length) {
                String sourceCode = this.units[u].getSourceCode();
                IProblem[] problems = this.unitResults[u].problems;
                if (problems != null && problems.length > 0) {
                    int i = 0;
                    while (i < problems.length) {
                        IProblem problem = problems[i];
                        problemBuffer.append(i + 1);
                        problemBuffer.append(". ");
                        problemBuffer.append(problem.getMessage());
                        if (problem.getSourceStart() >= 0 && problem.getSourceEnd() >= 0) {
                            int problemStartIndex = sourceCode.lastIndexOf("\n", problem.getSourceStart()) + 1;
                            int problemEndIndex = sourceCode.indexOf("\n", problem.getSourceEnd());
                            if (problemEndIndex < 0) {
                                problemEndIndex = sourceCode.length();
                            }
                            problemBuffer.append("\n");
                            problemBuffer.append(sourceCode.substring(problemStartIndex, problemEndIndex));
                            problemBuffer.append("\n");
                            int j = problemStartIndex;
                            while (j < problem.getSourceStart()) {
                                problemBuffer.append(" ");
                                ++j;
                            }
                            if (problem.getSourceStart() == problem.getSourceEnd()) {
                                problemBuffer.append("^");
                            } else {
                                problemBuffer.append("<");
                                j = problem.getSourceStart() + 1;
                                while (j < problem.getSourceEnd()) {
                                    problemBuffer.append("-");
                                    ++j;
                                }
                                problemBuffer.append(">");
                            }
                            problemBuffer.append("\n");
                        }
                        ++i;
                    }
                    problemBuffer.append(problems.length);
                    problemBuffer.append(" errors\n");
                }
                ++u;
            }
            return problemBuffer.length() > 0 ? problemBuffer.toString() : null;
        }

        public boolean hasMissingMethods() {
            CompilationUnitResult[] compilationUnitResultArray = this.unitResults;
            int n = this.unitResults.length;
            int n2 = 0;
            while (n2 < n) {
                CompilationUnitResult unitResult = compilationUnitResultArray[n2];
                if (unitResult.hasMissingMethods()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public CompilationUnit[] processCompilationUnits() {
            CompilationUnit[] compilationUnits = new CompilationUnit[this.units.length];
            int i = 0;
            while (i < compilationUnits.length) {
                if (this.unitResults[i].hasMissingMethods()) {
                    this.units[i] = this.compiler.recreateCompileUnit(this.units[i], this.unitResults[i].getMissingMethods());
                    this.unitResults[i].resolveMissingMethods();
                }
                compilationUnits[i] = new CompilationUnit(this.units[i].getSourceCode(), this.units[i].getCompileName());
                ++i;
            }
            this.reset();
            return compilationUnits;
        }

        protected void reset() {
            int i = 0;
            while (i < this.unitResults.length) {
                if (this.unitResults[i] == null) {
                    this.unitResults[i] = new CompilationUnitResult();
                } else {
                    this.unitResults[i].reset();
                }
                ++i;
            }
        }

        protected IProblem[] getJavaCompilationErrors(CompilationResult result) {
            return result.getErrors();
        }
    }
}

