/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.builder.jdt;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.eclipse.builder.jdt.CompilationUnit;
import net.sf.jasperreports.eclipse.builder.jdt.JRJdtCompiler;
import net.sf.jasperreports.eclipse.builder.jdt.NameEnvironmentAnswerFactory;
import net.sf.jasperreports.eclipse.classpath.ClassLoaderUtil;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.util.JRLoader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class NameEnvironement
implements INameEnvironment {
    public JRCompilationUnit[] units;
    private final JRJdtCompiler jrJdtCompiler;
    private Map<String, NameEnvironmentAnswer> map = new HashMap<String, NameEnvironmentAnswer>();
    private Map<String, Boolean> pmap = new HashMap<String, Boolean>();

    public NameEnvironement(JRJdtCompiler jrJdtCompiler, JRCompilationUnit[] units) {
        this.jrJdtCompiler = jrJdtCompiler;
        this.units = units;
    }

    public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
        StringBuffer result = new StringBuffer();
        String sep = "";
        int i = 0;
        while (i < compoundTypeName.length) {
            result.append(sep);
            result.append(compoundTypeName[i]);
            sep = ".";
            ++i;
        }
        return this.findType(result.toString());
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        StringBuffer result = new StringBuffer();
        String sep = "";
        int i = 0;
        while (i < packageName.length) {
            result.append(sep);
            result.append(packageName[i]);
            sep = ".";
            ++i;
        }
        result.append(sep);
        result.append(typeName);
        return this.findType(result.toString());
    }

    private int getClassIndex(String className) {
        int classIdx = 0;
        while (classIdx < this.units.length) {
            if (className.equals(this.units[classIdx].getName())) {
                return classIdx;
            }
            ++classIdx;
        }
        return -1;
    }

    protected NameEnvironmentAnswer findType(String className) {
        NameEnvironmentAnswer ne = this.map.get(className);
        if (ne != null) {
            return ne;
        }
        if (ClassLoaderUtil.packages.contains(className)) {
            return null;
        }
        try {
            int classIdx = this.getClassIndex(className);
            if (classIdx >= 0) {
                ne = NameEnvironmentAnswerFactory.getCompilationUnit(new CompilationUnit(this.units[classIdx].getSourceCode(), className));
            } else {
                String resourceName = String.valueOf(className.replace('.', '/')) + ".class";
                byte[] classBytes = this.getResource(resourceName);
                if (classBytes != null) {
                    ne = NameEnvironmentAnswerFactory.getClassFileReader(new ClassFileReader(classBytes, className.toCharArray(), true));
                }
            }
        }
        catch (JRException e) {
            JRJdtCompiler.log.error((Object)"Compilation error", (Throwable)e);
        }
        catch (ClassFormatException exc) {
            JRJdtCompiler.log.error((Object)"Compilation error", (Throwable)exc);
        }
        catch (InvocationTargetException e) {
            throw new JRRuntimeException("Not able to create NameEnvironmentAnswer", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new JRRuntimeException("Not able to create NameEnvironmentAnswer", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new JRRuntimeException("Not able to create NameEnvironmentAnswer", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JRRuntimeException("Not able to create NameEnvironmentAnswer", (Throwable)e);
        }
        this.map.put(className, ne);
        return ne;
    }

    protected byte[] getResource(String name) throws JRException {
        byte[] res = null;
        InputStream is = this.jrJdtCompiler.getResource(name);
        if (is != null) {
            try {
                res = JRLoader.loadBytes((InputStream)is);
            }
            finally {
                FileUtils.closeStream(is);
            }
        }
        return res;
    }

    protected boolean isPackage(String result) {
        Boolean b;
        block10: {
            b = this.pmap.get(result);
            if (b != null) {
                return b;
            }
            b = ClassLoaderUtil.packages.contains(result);
            if (b.booleanValue()) {
                return b;
            }
            int classIdx = this.getClassIndex(result);
            if (classIdx >= 0) {
                b = false;
            } else {
                String resourceName = String.valueOf(result.replace('.', '/')) + ".class";
                b = true;
                InputStream is = this.jrJdtCompiler.getResource(resourceName);
                if (is != null) {
                    try {
                        try {
                            b = is.read() < 0;
                        }
                        catch (IOException iOException) {
                            FileUtils.closeStream(is);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeStream(is);
                        throw throwable;
                    }
                    FileUtils.closeStream(is);
                }
            }
        }
        this.pmap.put(result, b);
        return b;
    }

    public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        StringBuffer result = new StringBuffer();
        String sep = "";
        if (parentPackageName != null) {
            int i = 0;
            while (i < parentPackageName.length) {
                result.append(sep);
                result.append(parentPackageName[i]);
                sep = ".";
                ++i;
            }
        }
        if (Character.isUpperCase(packageName[0]) && !this.isPackage(result.toString())) {
            return false;
        }
        result.append(sep);
        result.append(packageName);
        return this.isPackage(result.toString());
    }

    public void cleanup() {
    }
}

