/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.secret;

import java.text.MessageFormat;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.SecureStorageUtils;
import net.sf.jasperreports.util.SecretsProvider;
import org.eclipse.equinox.security.storage.StorageException;

public class EclipseSecretsProvider
implements SecretsProvider {
    public static final String SECRET_NODE_ID = "net.sf.jasperreports.jss";

    public String getSecret(String key) {
        try {
            String value = SecureStorageUtils.readFromDefaultSecurePreferences(this.getSecretNodeId(), key);
            return value != null ? value : key;
        }
        catch (StorageException ex) {
            JasperReportsPlugin.getDefault().logError(MessageFormat.format("Unable to recover the value for key {0} inside the secure storage ''{1}''.", key, this.getSecretNodeId()), ex);
            UIUtils.showError(ex);
            return key;
        }
    }

    public boolean hasSecret(String key) {
        try {
            return SecureStorageUtils.readFromDefaultSecurePreferences(this.getSecretNodeId(), key) != null;
        }
        catch (StorageException ex) {
            JasperReportsPlugin.getDefault().logError(MessageFormat.format("Unable to recover the value for key {0} inside the secure storage ''{1}''.", key, this.getSecretNodeId()), ex);
            UIUtils.showError(ex);
            return false;
        }
    }

    public String getSecretNodeId() {
        return SECRET_NODE_ID;
    }
}

