/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.ui;

import net.sf.jasperreports.eclipse.classpath.JavaProjectClassLoader;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.ReportLoader;
import net.sf.jasperreports.eclipse.viewer.IReportViewer;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.convert.ReportConverter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;

public final class ReportPreviewUtil {
    public static void loadFileIntoViewer(final IFile file, final IReportViewer viewer, Display display) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                block8: {
                    if (viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                        try {
                            ClassLoader projectClassLoader = ReportPreviewUtil.createProjectClassLoader(file.getProject());
                            if (projectClassLoader != null) {
                                Thread.currentThread().setContextClassLoader(projectClassLoader);
                            }
                            try {
                                JRReport report = ReportLoader.loadReport(file);
                                if (report == null) {
                                    viewer.setReport(null);
                                    break block8;
                                }
                                viewer.setReport(new ReportConverter((JasperReportsContext)DefaultJasperReportsContext.getInstance(), report, false).getJasperPrint());
                            }
                            catch (Throwable t) {
                                UIUtils.showError(t);
                            }
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(oldClassLoader);
                        }
                    }
                }
            }
        });
    }

    public static ClassLoader createProjectClassLoader(IProject project) {
        JavaProjectClassLoader classLoader = null;
        try {
            IJavaProject javaProject = null;
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                javaProject = JavaCore.create((IProject)project);
                javaProject.open(null);
                classLoader = JavaProjectClassLoader.instance(javaProject, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        return classLoader;
    }
}

