/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.ui.util;

import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PersistentLocationDialog
extends Dialog {
    protected static final String DIALOG_X = "dialogX";
    protected static final String DIALOG_Y = "dialogY";
    protected static final String DIALOG_WIDTH = "dialogWidth";
    protected static final String DIALOG_HEIGHT = "dialogHeight";
    private boolean saveSettings = true;
    protected int defwidth = -1;
    protected int defheight = -1;

    protected PersistentLocationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        if (this.saveSettings) {
            String dialogID = ((Object)((Object)this)).getClass().getName();
            IDialogSettings settings = JasperReportsPlugin.getDefault().getDialogSettings().getSection(dialogID);
            if (settings == null) {
                settings = JasperReportsPlugin.getDefault().getDialogSettings().addNewSection(dialogID);
            }
            return settings;
        }
        return super.getDialogBoundsSettings();
    }

    protected void initializeBounds() {
        super.initializeBounds();
        if (this.resizeHasOccurred) {
            Shell shell = this.getShell();
            Point initialLocation = this.getInitialLocation(shell.getSize());
            shell.setLocation(initialLocation);
        }
    }

    protected Point getInitialLocation(Point initialSize) {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings != null) {
            try {
                int x = settings.getInt(DIALOG_X);
                int y = settings.getInt(DIALOG_Y);
                Point result = new Point(x, y);
                if (this.isInsideMonitor(result)) {
                    return result;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.getCenteredMonitorLocation(initialSize);
    }

    protected Point getInitialSize() {
        IDialogSettings settings;
        if (this.isResizable() && (settings = this.getDialogBoundsSettings()) != null) {
            try {
                int width = settings.getInt(DIALOG_WIDTH);
                int height = settings.getInt(DIALOG_HEIGHT);
                return new Point(width, height);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.defwidth > 0 && this.defheight > 0) {
            return new Point(this.defwidth, this.defheight);
        }
        return super.getInitialSize();
    }

    protected boolean isInsideMonitor(Point currentLocation) {
        boolean isInside = false;
        Rectangle currentBounds = new Rectangle(0, 0, 0, 0);
        Monitor[] monitorArray = this.getShell().getDisplay().getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            Rectangle monitorBounds = monitor.getBounds();
            int endWidth = monitorBounds.x + monitorBounds.width;
            if (endWidth > currentBounds.width) {
                currentBounds.width = endWidth;
            }
            if (monitorBounds.x < currentBounds.x) {
                currentBounds.x = monitorBounds.x;
            }
            if (currentLocation.x > currentBounds.x && currentLocation.x < currentBounds.width) {
                if (currentLocation.y > monitorBounds.y && currentLocation.y < monitorBounds.height) {
                    isInside = true;
                    break;
                }
                isInside = false;
                break;
            }
            ++n2;
        }
        return isInside;
    }

    protected void saveDialogBounds(Shell shell) {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings != null) {
            Point shellLocation = shell.getLocation();
            Point shellSize = shell.getSize();
            settings.put(DIALOG_X, shellLocation.x);
            settings.put(DIALOG_Y, shellLocation.y);
            settings.put(DIALOG_WIDTH, shellSize.x);
            settings.put(DIALOG_HEIGHT, shellSize.y);
        }
    }

    public boolean close() {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.saveDialogBounds(this.getShell());
        }
        return super.close();
    }

    protected Point getCenteredMonitorLocation(Point initialSize) {
        Monitor monitor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getMonitor();
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    protected void setSaveSettings(boolean value) {
        this.saveSettings = value;
    }

    public void setDefaultSize(int defwidth, int defheight) {
        this.defwidth = defwidth;
        this.defheight = defheight;
    }
}

