/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class CastorHelper {
    public static Object read(InputStream is, String mappingFile) {
        Object object = null;
        InputStream mis = null;
        try {
            try {
                mis = JRLoader.getLocationInputStream((String)mappingFile);
                Mapping mapping = new Mapping();
                mapping.loadMapping(new InputSource(mis));
                object = CastorHelper.read(is, mapping);
            }
            catch (JRException e) {
                throw new JRRuntimeException((Throwable)e);
            }
        }
        finally {
            FileUtils.closeStream(mis);
        }
        return object;
    }

    public static Object read(Node node, String mappingFile) {
        Object object = null;
        InputStream mis = null;
        try {
            try {
                mis = JRLoader.getLocationInputStream((String)mappingFile);
                Mapping mapping = new Mapping();
                mapping.loadMapping(new InputSource(mis));
                object = CastorHelper.read(node, mapping);
            }
            catch (JRException e) {
                throw new JRRuntimeException((Throwable)e);
            }
        }
        finally {
            FileUtils.closeStream(mis);
        }
        return object;
    }

    public static Object read(InputStream is, Mapping mapping) {
        Object object = null;
        try {
            Unmarshaller unmarshaller = new Unmarshaller(mapping);
            unmarshaller.setWhitespacePreserve(true);
            object = unmarshaller.unmarshal(new InputSource(is));
        }
        catch (MappingException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (MarshalException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        return object;
    }

    public static Object read(Node node, Mapping mapping) {
        Object object = null;
        try {
            Unmarshaller unmarshaller = new Unmarshaller(mapping);
            unmarshaller.setWhitespacePreserve(true);
            object = unmarshaller.unmarshal(node);
        }
        catch (MappingException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (MarshalException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        return object;
    }

    public static Object read(InputStream is, Class<?> clazz) {
        return CastorHelper.read(is, CastorHelper.getMappingFileName(clazz));
    }

    public static Object read(Node node, Class<?> clazz) {
        return CastorHelper.read(node, CastorHelper.getMappingFileName(clazz));
    }

    public static void write(Object object, String mappingFile, Writer writer) {
        InputStream mis = null;
        try {
            try {
                mis = JRLoader.getLocationInputStream((String)mappingFile);
                Mapping mapping = new Mapping();
                mapping.loadMapping(new InputSource(mis));
                CastorHelper.write(object, mapping, writer);
            }
            catch (JRException e) {
                throw new JRRuntimeException((Throwable)e);
            }
        }
        finally {
            FileUtils.closeStream(mis);
        }
    }

    public static void write(Object object, Mapping mapping, Writer writer) {
        try {
            Marshaller marshaller = new Marshaller(writer);
            marshaller.setMapping(mapping);
            marshaller.setMarshalAsDocument(false);
            marshaller.marshal(object);
        }
        catch (IOException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (MappingException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (MarshalException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    public static void write(Object object, String mappingFile, File file) {
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(file);
                CastorHelper.write(object, mappingFile, (Writer)writer);
            }
            catch (IOException e) {
                throw new JRRuntimeException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeStream(writer);
            throw throwable;
        }
        FileUtils.closeStream(writer);
    }

    public static void write(Object object, Mapping mapping, File file) {
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(file);
                CastorHelper.write(object, mapping, (Writer)writer);
            }
            catch (IOException e) {
                throw new JRRuntimeException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeStream(writer);
            throw throwable;
        }
        FileUtils.closeStream(writer);
    }

    public static String write(Object object, String mappingFile) {
        StringWriter writer = new StringWriter();
        try {
            CastorHelper.write(object, mappingFile, (Writer)writer);
        }
        finally {
            FileUtils.closeStream(writer);
        }
        return writer.toString();
    }

    public static String write(Object object, Mapping mapping) {
        StringWriter writer = new StringWriter();
        try {
            CastorHelper.write(object, mapping, (Writer)writer);
        }
        finally {
            FileUtils.closeStream(writer);
        }
        String res = writer.toString();
        return res;
    }

    public static String write(Object object) {
        StringWriter writer = new StringWriter();
        try {
            CastorHelper.write(object, CastorHelper.getMappingFileName(object.getClass()), (Writer)writer);
        }
        finally {
            FileUtils.closeStream(writer);
        }
        return writer.toString();
    }

    private static String getMappingFileName(Class<?> clazz) {
        return String.valueOf(clazz.getName().replace(".", "/")) + ".xml";
    }
}

