/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.util.FilePrefUtil;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class ResourcePreferences
extends EclipsePreferences {
    protected static Set<String> loadedNodes = Collections.synchronizedSet(new HashSet());
    private IFile file;
    private IEclipsePreferences loadLevel;
    private boolean initialized = false;
    private boolean isReading;
    private IFile pfile;
    private String qualifier;

    public ResourcePreferences() {
        super(null, null);
    }

    private ResourcePreferences(EclipsePreferences parent, String name) {
        super(parent, name);
        String path = this.absolutePath().replaceAll("/resource", "").replace(';', '/');
        if (name != null && path.endsWith(name)) {
            path = path.substring(0, path.length() - name.length() - 1);
            this.qualifier = name;
        }
        if (!path.isEmpty()) {
            this.pfile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        }
        this.initialize();
    }

    private String[] computeChildren() {
        return EMPTY_STRING_ARRAY;
    }

    public void flush() throws BackingStoreException {
        if (this.isReading) {
            return;
        }
        super.flush();
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.pfile == null || this.qualifier == null) {
                return null;
            }
            this.loadLevel = this;
        }
        return this.loadLevel;
    }

    protected IPath getLocation() {
        if (this.pfile == null || this.qualifier == null) {
            return null;
        }
        IPath path = this.pfile.getLocation();
        return this.computeLocation(path, this.qualifier);
    }

    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Object context) {
        return new ResourcePreferences(nodeParent, nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        if (this.initialized) {
            return;
        }
        try {
            ResourcePreferences resourcePreferences = this;
            synchronized (resourcePreferences) {
                String[] names = this.computeChildren();
                int i = 0;
                while (i < names.length) {
                    this.addChild(names[i], null);
                    ++i;
                }
            }
        }
        finally {
            this.initialized = true;
        }
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.absolutePath());
    }

    protected boolean isAlreadyLoaded(String path) {
        return loadedNodes.contains(path);
    }

    protected void load() throws BackingStoreException {
        if (this.pfile == null || !this.pfile.exists()) {
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug((String)NLS.bind((String)Messages.ResourcePreferences_ErrPreferenceFileNotExist, (Object)this.absolutePath()));
            }
            return;
        }
        ((ResourcePreferences)this.parent).initialize();
        if (Policy.DEBUG_PREFERENCES) {
            Policy.debug((String)NLS.bind((String)Messages.ResourcePreferences_LoadingPreferencesFile, (Object)this.pfile.getFullPath()));
        }
        try {
            Properties result = FilePrefUtil.loadPreferences(this.pfile);
            ResourcePreferences.convertFromProperties((EclipsePreferences)this, (Properties)result, (boolean)true);
            loadedNodes.add(this.absolutePath());
        }
        catch (CoreException e) {
            String message = NLS.bind((String)Messages.ResourcePreferences_ErrorLoadingPreferenceFile, (Object)this.pfile.getFullPath());
            ResourcePreferences.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e));
            throw new BackingStoreException(message);
        }
    }

    public boolean nodeExists(String path) throws BackingStoreException {
        if (path.length() == 0) {
            return super.nodeExists(path);
        }
        if (path.charAt(0) == '/') {
            return super.nodeExists(path);
        }
        if (path.indexOf(47) != -1) {
            return super.nodeExists(path);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(path).exists() || super.nodeExists(path);
    }

    protected void save() throws BackingStoreException {
        Properties table = this.convertToProperties(new Properties(), "");
        table.put("eclipse.preferences.version", "1");
        try {
            Map map = this.pfile.getPersistentProperties();
            for (QualifiedName qn : map.keySet()) {
                try {
                    this.pfile.setPersistentProperty(qn, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            FilePrefUtil.savePreferences(this.pfile, this.qualifier, table);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }
}

