/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sf.jasperreports.eclipse.util.FileUtils;

public class ZipUtils {
    public void unZipFiles(String zipFile, String outputFolder) {
        byte[] buffer = new byte[1024];
        try {
            File folder = new File(outputFolder);
            if (!folder.exists()) {
                folder.mkdir();
            }
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(String.valueOf(outputFolder) + File.separator + fileName);
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public boolean zipFiles(String srcFolder, String destZipFile) {
        ArrayList<String> folderList = new ArrayList<String>();
        folderList.add(srcFolder);
        return this.zipFiles(folderList, destZipFile);
    }

    public boolean zipFiles(List<String> srcFolders, String destZipFile) {
        boolean result = false;
        try {
            this.zipFolder(srcFolders, destZipFile);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean zipFolderContent(String srcFolder, String destZipFile) {
        boolean result;
        block6: {
            result = false;
            ZipOutputStream zip = null;
            FileOutputStream fileWriter = null;
            try {
                try {
                    fileWriter = new FileOutputStream(destZipFile);
                    zip = new ZipOutputStream(fileWriter);
                    File folder = new File(srcFolder);
                    String[] stringArray = folder.list();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileName = stringArray[n2];
                        this.addFileToZip("", String.valueOf(srcFolder) + "/" + fileName, zip, false);
                        ++n2;
                    }
                    result = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FileUtils.closeStream(zip);
                    FileUtils.closeStream(fileWriter);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(zip);
                FileUtils.closeStream(fileWriter);
                throw throwable;
            }
            FileUtils.closeStream(zip);
            FileUtils.closeStream(fileWriter);
        }
        return result;
    }

    private void zipFolder(List<String> srcFolders, String destZipFile) throws Exception {
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
        fileWriter = new FileOutputStream(destZipFile);
        zip = new ZipOutputStream(fileWriter);
        for (String srcFolder : srcFolders) {
            this.addFolderToZip("", srcFolder, zip);
        }
        zip.flush();
        zip.close();
    }

    private void addFileToZip(String path, String srcFile, ZipOutputStream zip, boolean flag) throws Exception {
        File folder = new File(srcFile);
        if (flag) {
            zip.putNextEntry(new ZipEntry(String.valueOf(path) + "/" + folder.getName() + "/"));
        } else if (folder.isDirectory()) {
            this.addFolderToZip(path, srcFile, zip);
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(srcFile);
            zip.putNextEntry(new ZipEntry(String.valueOf(path) + "/" + folder.getName()));
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
            in.close();
        }
    }

    private void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFolder);
        if (folder.list().length == 0) {
            this.addFileToZip(path, srcFolder, zip, true);
        } else {
            String[] stringArray = folder.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                if (path.equals("")) {
                    this.addFileToZip(folder.getName(), String.valueOf(srcFolder) + "/" + fileName, zip, false);
                } else {
                    this.addFileToZip(String.valueOf(path) + "/" + folder.getName(), String.valueOf(srcFolder) + "/" + fileName, zip, false);
                }
                ++n2;
            }
        }
    }
}

