/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.viewer;

import java.net.URL;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.StringUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class BrowserUtils {
    public static final String SWT_BROWSER_XUL_RUNNER_PATH = "org.eclipse.swt.browser.XULRunnerPath";
    public static final String SWT_BROWSER_EDGE_TYPE = "org.eclipse.swt.browser.DefaultType";
    public static final String SWT_BROWSER_EDGE_WEBVIEW_LOCATION = "org.eclipse.swt.browser.EdgeDir";

    public static void openLink(String url) {
        try {
            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null);
            browser.openURL(new URL(url));
        }
        catch (Exception e) {
            UIUtils.showError(e);
        }
    }

    public static void openRawLink(String url) {
        Program.launch((String)url);
    }

    public static Browser getSWTBrowserWidget(Composite parent, int style) {
        return BrowserUtils.getSWTBrowserWidget(parent, style, true);
    }

    public static Browser getSWTBrowserWidget(Composite parent, int style, boolean popupSupported) {
        String xulRunnerLocation = System.getProperty(SWT_BROWSER_XUL_RUNNER_PATH);
        Browser browser = null;
        browser = xulRunnerLocation != null && !xulRunnerLocation.isEmpty() ? new Browser(parent, style | 0x8000) : new Browser(parent, style);
        if (popupSupported) {
            BrowserUtils.enablePopupSupport(UIUtils.getDisplay(), browser);
        }
        return browser;
    }

    public static void enablePopupSupport(final Display display, Browser browser) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                if (!event.required) {
                    return;
                }
                Shell shell = new Shell(display);
                shell.setText("");
                shell.setLayout((Layout)new FillLayout());
                Browser browser = new Browser((Composite)shell, 0);
                BrowserUtils.enablePopupSupport(display, browser);
                event.browser = browser;
            }
        });
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                if (event.location != null) {
                    shell.setLocation(event.location);
                }
                if (event.size != null) {
                    Point size = event.size;
                    shell.setSize(shell.computeSize(size.x, size.y));
                }
                shell.open();
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
    }

    public static void openExternalBrowser(final String url) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                URL helpSystemUrl = PlatformUI.getWorkbench().getHelpSystem().resolve(url, true);
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.getExternalBrowser();
                    browser.openURL(helpSystemUrl);
                }
                catch (PartInitException partInitException) {}
            }
        });
    }

    public static boolean isEdgeWebViewEnabled() {
        String pEdgeDefaultType = System.getProperty(SWT_BROWSER_EDGE_TYPE);
        String pEdgeWebViewLocation = System.getProperty(SWT_BROWSER_EDGE_WEBVIEW_LOCATION);
        return !StringUtils.isNullOrEmpty(pEdgeDefaultType) && !StringUtils.isNullOrEmpty(pEdgeWebViewLocation);
    }
}

