/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.utils;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.ClassLoaderResource;
import net.sf.jasperreports.engine.util.ClassUtils;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.ObjectUtils;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;
import org.eclipse.osgi.util.NLS;

public class JRExtensionsUtils {
    public static <T> List<T> getReloadedExtensions(Class<T> extensionType, String registryId) {
        ArrayList extensions = new ArrayList();
        HashMap<URL, JRPropertiesMap> allPropertiesMap = new HashMap<URL, JRPropertiesMap>();
        List classLoaderResources = JRLoader.getClassLoaderResources((String)"jasperreports_extension.properties");
        for (ClassLoaderResource cr : classLoaderResources) {
            JRPropertiesMap properties = JRPropertiesMap.loadProperties((URL)cr.getUrl());
            URL duplicateURL = JRExtensionsUtils.detectDuplicate(properties, allPropertiesMap);
            if (duplicateURL == null) {
                List factoryProps = JRPropertiesUtil.getProperties((JRPropertiesMap)properties, (String)"net.sf.jasperreports.extension.registry.factory.");
                for (JRPropertiesUtil.PropertySuffix factoryProp : factoryProps) {
                    String factoryRegistryId = factoryProp.getSuffix();
                    String factoryClass = factoryProp.getValue();
                    try {
                        if (!factoryRegistryId.equals(registryId)) continue;
                        ExtensionsRegistryFactory factory = (ExtensionsRegistryFactory)ClassUtils.instantiateClass((String)factoryClass, ExtensionsRegistryFactory.class);
                        ExtensionsRegistry registry = factory.createRegistry(registryId, properties);
                        extensions.addAll(registry.getExtensions(extensionType));
                    }
                    catch (JRRuntimeException ex) {
                        ex.printStackTrace();
                        JasperReportsPlugin.getDefault().logError(MessageFormat.format("Unable to load the extension class {0} for registry {1}", factoryClass, registryId), ex);
                    }
                }
                allPropertiesMap.put(cr.getUrl(), properties);
                continue;
            }
            JasperReportsPlugin.getDefault().logWarning(NLS.bind((String)"Extension resource {0} was found to be a duplicate of {1}", (Object[])new Object[]{cr.getUrl(), duplicateURL}));
        }
        return extensions;
    }

    private static URL detectDuplicate(JRPropertiesMap properties, Map<URL, JRPropertiesMap> allPropertiesMap) {
        for (URL url : allPropertiesMap.keySet()) {
            JRPropertiesMap entryProperties = allPropertiesMap.get(url);
            if (!ObjectUtils.equals((JRPropertiesMap)properties, (JRPropertiesMap)entryProperties)) continue;
            return url;
        }
        return null;
    }
}

