/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.manager;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.babel.core.configuration.ConfigurationManager;
import org.eclipse.babel.core.configuration.IConfiguration;
import org.eclipse.babel.core.message.manager.RBManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class ResourceBundleDetectionVisitor
implements IResourceVisitor,
IResourceDeltaVisitor {
    private RBManager manager = null;
    private final String RB_MARKER_ID = "org.eclipse.babel.tapiji.tools.core.ResourceBundleAuditMarker";
    private static final String DELIMITER = ";";
    private static final String ATTRIBUTE_DELIMITER = ":";

    public ResourceBundleDetectionVisitor(RBManager manager) {
        this.manager = manager;
    }

    public boolean visit(IResource resource) throws CoreException {
        try {
            if (this.isResourceBundleFile(resource)) {
                this.manager.addBundleResource(resource);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        return !this.isResourceBundleFile(resource);
    }

    private boolean isResourceBundleFile(IResource file) {
        boolean isValied = false;
        if (file != null && file instanceof IFile && !file.isDerived() && file.getFileExtension() != null && file.getFileExtension().equalsIgnoreCase("properties")) {
            isValied = true;
            List<CheckItem> list = this.getBlacklistItems();
            for (CheckItem item : list) {
                if (!item.getChecked() || !file.getFullPath().toString().matches(item.getName())) continue;
                isValied = false;
                if (!this.hasResourceBundleMarker(file)) continue;
                try {
                    file.deleteMarkers("org.eclipse.babel.tapiji.tools.core.ResourceBundleAuditMarker", true, 2);
                }
                catch (CoreException coreException) {}
            }
        }
        return isValied;
    }

    private List<CheckItem> getBlacklistItems() {
        IConfiguration configuration = ConfigurationManager.getInstance().getConfiguration();
        if (configuration != null) {
            return this.convertStringToList(configuration.getNonRbPattern());
        }
        return new ArrayList<CheckItem>();
    }

    private List<CheckItem> convertStringToList(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, DELIMITER);
        int tokenCount = tokenizer.countTokens();
        LinkedList<CheckItem> elements = new LinkedList<CheckItem>();
        int i = 0;
        while (i < tokenCount) {
            StringTokenizer attribute = new StringTokenizer(tokenizer.nextToken(), ATTRIBUTE_DELIMITER);
            String name = attribute.nextToken();
            boolean checked = attribute.nextToken().equals("true");
            elements.add(new CheckItem(name, checked));
            ++i;
        }
        return elements;
    }

    public boolean hasResourceBundleMarker(IResource r) {
        try {
            return r.findMarkers("org.eclipse.babel.tapiji.tools.core.ResourceBundleAuditMarker", true, 2).length > 0;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private class CheckItem {
        boolean checked;
        String name;

        public CheckItem(String item, boolean checked) {
            this.name = item;
            this.checked = checked;
        }

        public String getName() {
            return this.name;
        }

        public boolean getChecked() {
            return this.checked;
        }
    }
}

