/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.resource.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.eclipse.babel.core.message.resource.internal.AbstractPropertiesResource;
import org.eclipse.babel.core.message.resource.ser.PropertiesDeserializer;
import org.eclipse.babel.core.message.resource.ser.PropertiesSerializer;
import org.eclipse.babel.core.util.FileChangeListener;
import org.eclipse.babel.core.util.FileMonitor;

public class PropertiesFileResource
extends AbstractPropertiesResource {
    private File file;
    private FileChangeListenerImpl fileChangeListener;

    public PropertiesFileResource(Locale locale, PropertiesSerializer serializer, PropertiesDeserializer deserializer, File file) throws FileNotFoundException {
        super(locale, serializer, deserializer);
        this.file = file;
        this.fileChangeListener = new FileChangeListenerImpl();
        FileMonitor.getInstance().addFileChangeListener((FileChangeListener)this.fileChangeListener, file, 2000L);
    }

    @Override
    public String getText() {
        StringWriter outputStream;
        FileReader inputStream;
        block6: {
            inputStream = null;
            outputStream = null;
            if (this.file.exists()) break block6;
            this.closeReader(inputStream);
            this.closeWriter(outputStream);
            return "";
        }
        try {
            try {
                int c;
                inputStream = new FileReader(this.file);
                outputStream = new StringWriter();
                while ((c = inputStream.read()) != -1) {
                    outputStream.write(c);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot get properties file text. Handle better.", e);
            }
        }
        catch (Throwable throwable) {
            this.closeReader(inputStream);
            this.closeWriter(outputStream);
            throw throwable;
        }
        this.closeReader(inputStream);
        this.closeWriter(outputStream);
        return outputStream.toString();
    }

    @Override
    public void setText(String content) {
        StringReader inputStream = null;
        FileWriter outputStream = null;
        try {
            try {
                int c;
                inputStream = new StringReader(content);
                outputStream = new FileWriter(this.file);
                while ((c = inputStream.read()) != -1) {
                    outputStream.write(c);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot get properties file text. Handle better.", e);
            }
        }
        catch (Throwable throwable) {
            this.closeReader(inputStream);
            this.closeWriter(outputStream);
            throw throwable;
        }
        this.closeReader(inputStream);
        this.closeWriter(outputStream);
    }

    @Override
    public Object getSource() {
        return this.file;
    }

    @Override
    public String getResourceLocationLabel() {
        return this.file.getAbsolutePath();
    }

    private void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot close writer stream.", e);
            }
        }
    }

    public void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot close reader.", e);
            }
        }
    }

    @Override
    public void dispose() {
        FileMonitor.getInstance().removeFileChangeListener((FileChangeListener)this.fileChangeListener, this.file);
    }

    private class FileChangeListenerImpl
    implements FileChangeListener {
        private FileChangeListenerImpl() {
        }

        @Override
        public void fileChanged(File changedFile) {
            PropertiesFileResource.this.fireResourceChange(PropertiesFileResource.this);
        }
    }
}

