/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.resource.ser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.babel.core.message.IMessage;
import org.eclipse.babel.core.message.IMessagesBundle;
import org.eclipse.babel.core.message.internal.Message;
import org.eclipse.babel.core.message.resource.ser.IPropertiesDeserializerConfig;
import org.eclipse.babel.core.util.BabelUtils;

public class PropertiesDeserializer {
    private static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String KEY_VALUE_SEPARATORS = "=:";
    private IPropertiesDeserializerConfig config;

    public PropertiesDeserializer(IPropertiesDeserializerConfig config) {
        this.config = config;
    }

    public void deserialize(IMessagesBundle messagesBundle, String properties) {
        Locale locale = messagesBundle.getLocale();
        ArrayList<String> oldKeys = new ArrayList<String>(Arrays.asList(messagesBundle.getKeys()));
        ArrayList<String> newKeys = new ArrayList<String>();
        String[] lines = properties.split("\r\n|\r|\n");
        boolean doneWithFileComment = false;
        StringBuffer fileComment = new StringBuffer();
        StringBuffer lineComment = new StringBuffer();
        StringBuffer lineBuf = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            boolean isCommentedLine;
            String line = lines[i];
            lineBuf.setLength(0);
            lineBuf.append(line);
            int equalPosition = this.findKeyValueSeparator(line);
            boolean isRegularLine = line.matches("^[^#].*");
            boolean bl = isCommentedLine = doneWithFileComment && line.matches("^##[^#].*");
            if (equalPosition >= 1 && (isRegularLine || isCommentedLine)) {
                doneWithFileComment = true;
                String comment = "";
                if (lineComment.length() > 0) {
                    comment = lineComment.toString();
                    lineComment.setLength(0);
                }
                if (isCommentedLine) {
                    lineBuf.delete(0, 2);
                    equalPosition -= 2;
                }
                String backslash = "\\";
                while (lineBuf.lastIndexOf(backslash) == lineBuf.length() - 1) {
                    int lineBreakPosition = lineBuf.lastIndexOf(backslash);
                    lineBuf.replace(lineBreakPosition, lineBreakPosition + 1, "");
                    if (++i >= lines.length) continue;
                    String wrappedLine = lines[i].replaceFirst("^\\s*", "");
                    if (isCommentedLine) {
                        lineBuf.append(wrappedLine.replaceFirst("^##", ""));
                        continue;
                    }
                    lineBuf.append(wrappedLine);
                }
                String key = lineBuf.substring(0, equalPosition).trim();
                key = this.unescapeKey(key);
                String value = lineBuf.substring(equalPosition + 1).replaceFirst("^\\s*", "");
                if (value.startsWith("\\ ")) {
                    value = value.substring(1);
                }
                if (this.config != null && this.config.isUnicodeUnescapeEnabled()) {
                    key = this.convertEncodedToUnicode(key);
                    value = this.convertEncodedToUnicode(value);
                } else {
                    value = value.replaceAll("\\\\r", "\r");
                    value = value.replaceAll("\\\\n", "\n");
                }
                IMessage entry = messagesBundle.getMessage(key);
                if (entry == null) {
                    entry = new Message(key, locale);
                    messagesBundle.addMessage(entry);
                }
                entry.setActive(!isCommentedLine);
                entry.setComment(comment);
                entry.setText(value);
                newKeys.add(key);
            } else if (lineBuf.indexOf("#") == 0) {
                if (!doneWithFileComment) {
                    fileComment.append(lineBuf);
                    fileComment.append(SYSTEM_LINE_SEPARATOR);
                } else {
                    lineComment.append(lineBuf);
                    lineComment.append(SYSTEM_LINE_SEPARATOR);
                }
            } else {
                doneWithFileComment = true;
            }
            ++i;
        }
        oldKeys.removeAll(newKeys);
        messagesBundle.removeMessages(oldKeys.toArray(BabelUtils.EMPTY_STRINGS));
        messagesBundle.setComment(fileComment.toString());
    }

    private String convertEncodedToUnicode(String str) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = str.charAt(x++)) == 92 && x + 1 <= len) {
                if ((aChar = str.charAt(x++)) == 117 && x + 4 <= len) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = str.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                value = aChar;
                                System.err.println("PropertiesDeserializer: bad character encoding for string:" + str);
                            }
                        }
                        ++i;
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                } else if (aChar == 117) {
                    outBuffer.append("\\");
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    private int findKeyValueSeparator(String str) {
        int index = -1;
        int length = str.length();
        int i = 0;
        while (i < length) {
            char currentChar = str.charAt(i);
            if (currentChar == '\\') {
                ++i;
            } else if (KEY_VALUE_SEPARATORS.indexOf(currentChar) != -1) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private String unescapeKey(String key) {
        int length = key.length();
        StringBuffer buf = new StringBuffer();
        int index = 0;
        while (index < length) {
            char currentChar = key.charAt(index);
            if (currentChar != '\\') {
                buf.append(currentChar);
            }
            ++index;
        }
        return buf.toString();
    }
}

