/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.refactoring;

import org.eclipse.babel.core.message.IMessagesBundleGroup;
import org.eclipse.babel.core.message.manager.RBManager;
import org.eclipse.babel.core.refactoring.StandardRefactoring;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class KeyRefactoringDialog
extends TitleAreaDialog {
    private static final String REGEXP_RESOURCE_KEY = "[\\p{Alnum}\\.]*";
    private DialogConfiguration config;
    private String selectedKey = "";
    public static final String ALL_LOCALES = "All available";
    private Button okButton;
    private Button cancelButton;
    private Label projectLabel;
    private Label resourceBundleLabel;
    private Label oldKeyLabel;
    private Label newKeyLabel;
    private Label languageLabel;
    private Text oldKeyText;
    private Text newKeyText;
    private Text projectText;
    private Text resourceBundleText;
    private Text languageText;

    public KeyRefactoringDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.initLayout(dialogArea);
        return super.createDialogArea(parent);
    }

    private void initLayout(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        GridLayout gl = new GridLayout(2, true);
        GridData gd = new GridData(0x1000000, 0x1000000, true, true);
        Composite master = new Composite(parent, 0);
        master.setLayout((Layout)gl);
        master.setLayoutData((Object)gd);
        this.projectLabel = new Label(master, 0);
        this.projectLabel.setText("Project:");
        this.projectText = new Text(master, 2048);
        this.projectText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.projectText.setText(this.config.getProjectName());
        this.projectText.setEnabled(false);
        this.resourceBundleLabel = new Label(master, 0);
        this.resourceBundleLabel.setText("Resource-Bundle:");
        this.resourceBundleText = new Text(master, 2048);
        this.resourceBundleText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.resourceBundleText.setText(this.config.getPreselectedBundle());
        this.resourceBundleText.setEnabled(false);
        this.languageLabel = new Label(master, 0);
        this.languageLabel.setText("Language (Country):");
        this.languageText = new Text(master, 2048);
        this.languageText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.languageText.setText(ALL_LOCALES);
        this.languageText.setEnabled(false);
        this.oldKeyLabel = new Label(master, 0);
        this.oldKeyLabel.setText("Old key name:");
        this.oldKeyText = new Text(master, 2048);
        this.oldKeyText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.oldKeyText.setText(this.config.getPreselectedKey());
        this.oldKeyText.setEnabled(false);
        this.newKeyLabel = new Label(master, 0);
        this.newKeyLabel.setText("New key name:");
        this.newKeyText = new Text(master, 2048);
        this.newKeyText.setText(this.config.getPreselectedKey());
        this.newKeyText.setSelection(0, this.newKeyText.getText().length());
        this.newKeyText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.newKeyText.setFocus();
        this.newKeyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeyRefactoringDialog.this.selectedKey = KeyRefactoringDialog.this.newKeyText.getText();
                KeyRefactoringDialog.this.validate();
            }
        });
    }

    public void setDialogConfiguration(DialogConfiguration config) {
        this.config = config;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Rename resource key");
    }

    public void create() {
        super.create();
        this.setTitle("Rename resource key");
        this.setMessage("Please, specify the name of the new key. \r\nThe new value will automatically replace the old ones.");
    }

    public DialogConfiguration getConfig() {
        return this.config;
    }

    private boolean isValidResourceKey(String key) {
        boolean isValid = false;
        if (key != null && key.trim().length() > 0) {
            isValid = key.matches(REGEXP_RESOURCE_KEY);
        }
        return isValid;
    }

    private IMessagesBundleGroup getResourceBundle(String name, IProject project) {
        RBManager instance = RBManager.getInstance(project);
        return instance.getMessagesBundleGroup(name);
    }

    public boolean isResourceExisting(String bundleId, String key, IProject project) {
        boolean keyExists = false;
        IMessagesBundleGroup bGroup = this.getResourceBundle(bundleId, project);
        if (bGroup != null) {
            keyExists = bGroup.isKey(key);
        }
        return keyExists;
    }

    protected void validate() {
        IProject project;
        boolean keyValid = false;
        boolean keyValidChar = this.isValidResourceKey(this.selectedKey);
        String resourceBundle = this.config.getPreselectedBundle();
        if (!this.isResourceExisting(resourceBundle, this.selectedKey, project = StandardRefactoring.getProject(this.config.getProjectName()))) {
            keyValid = true;
        }
        String errorMessage = null;
        if (this.selectedKey.trim().length() == 0) {
            errorMessage = "No resource key specified.";
        } else if (!keyValidChar) {
            errorMessage = "The specified resource key contains invalid characters.";
        } else if (!keyValid) {
            errorMessage = "The specified resource key is already existing.";
        } else if (this.okButton != null) {
            this.okButton.setEnabled(true);
        }
        this.setErrorMessage(errorMessage);
        if (this.okButton != null && errorMessage != null) {
            this.okButton.setEnabled(false);
        } else {
            this.config.setNewKey(this.selectedKey);
            this.config.setSelectedLocale(ALL_LOCALES);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, "Ok", true);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyRefactoringDialog.this.setReturnCode(0);
                KeyRefactoringDialog.this.close();
            }
        });
        this.cancelButton = this.createButton(parent, 1, "Cancel", false);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyRefactoringDialog.this.setReturnCode(1);
                KeyRefactoringDialog.this.close();
            }
        });
        this.okButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    public class DialogConfiguration {
        String projectName;
        String preselectedKey;
        String preselectedBundle;
        String newKey;
        String selectedLocale;

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getPreselectedKey() {
            return this.preselectedKey;
        }

        public void setPreselectedKey(String preselectedKey) {
            this.preselectedKey = preselectedKey;
        }

        public String getPreselectedBundle() {
            return this.preselectedBundle;
        }

        public void setPreselectedBundle(String preselectedBundle) {
            this.preselectedBundle = preselectedBundle;
        }

        public String getNewKey() {
            return this.newKey;
        }

        public void setNewKey(String newKey) {
            this.newKey = newKey;
        }

        public String getSelectedLocale() {
            return this.selectedLocale;
        }

        public void setSelectedLocale(String selectedLocale) {
            this.selectedLocale = selectedLocale;
        }
    }
}

