/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.actions;

import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.babel.editor.internal.MessagesEditorChangeAdapter;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.jface.action.Action;

public class KeyTreeVisibleAction
extends Action {
    private AbstractMessagesEditor editor;

    public KeyTreeVisibleAction() {
        super("Show/Hide Key Tree", 2);
        this.setToolTipText("Show/hide the key tree");
        this.setImageDescriptor(UIUtils.getImageDescriptor("viewLeft.gif"));
    }

    public void setEditor(AbstractMessagesEditor editor) {
        this.editor = editor;
        editor.addChangeListener(new MessagesEditorChangeAdapter(){

            @Override
            public void keyTreeVisibleChanged(boolean visible) {
                KeyTreeVisibleAction.this.setChecked(visible);
            }
        });
        this.setChecked(editor.getI18NPage().isKeyTreeVisible());
    }

    public void run() {
        this.editor.getI18NPage().setKeyTreeVisible(!this.editor.getI18NPage().isKeyTreeVisible());
    }
}

