/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.builder;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.babel.core.util.BabelUtils;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleNatureAction
implements IObjectActionDelegate {
    private static final Logger LOGGER = Logger.getLogger(ToggleNatureAction.class.getName());
    private ISelection selection;

    public static void addOrRemoveNatureOnAllJavaProjects(boolean doAdd) {
        IProject[] projs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projs.length) {
            IProject project = projs[i];
            ToggleNatureAction.addOrRemoveNatureOnProject(project, doAdd, true);
            ++i;
        }
    }

    public static void addOrRemoveNatureOnProject(IProject project, boolean doAdd, boolean onlyJavaProject) {
        try {
            if (project.isAccessible() && (!onlyJavaProject || UIUtils.hasNature(project, "org.eclipse.jdt.core.javanature"))) {
                if (doAdd) {
                    if (project.getNature("com.jaspersoft.studio.babel.editor.rbeNature") == null) {
                        ToggleNatureAction.toggleNature(project);
                    }
                } else if (project.getNature("com.jaspersoft.studio.babel.editor.rbeNature") != null) {
                    ToggleNatureAction.toggleNature(project);
                }
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)this.selection).toList()) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                ToggleNatureAction.toggleNature(project);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private static void setBuilder(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.babel.editor.rbeBuilder")) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.babel.editor.rbeBuilder");
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
        project.setDescription(desc, null);
    }

    private static void toggleNature(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if ("com.jaspersoft.studio.babel.editor.rbeNature".equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    project.setDescription(description, null);
                    return;
                }
                ++i;
            }
            Object[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "com.jaspersoft.studio.babel.editor.rbeNature";
            LOGGER.log(Level.INFO, "New natures: " + BabelUtils.join(newNatures, ", "));
            description.setNatureIds((String[])newNatures);
            project.setDescription(description, null);
            ToggleNatureAction.setBuilder(project);
        }
        catch (CoreException coreException) {}
    }
}

