/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.bundle;

import java.util.ArrayList;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.editor.bundle.DefaultBundleGroupStrategy;
import org.eclipse.babel.editor.bundle.NLFragmentBundleGroupStrategy;
import org.eclipse.babel.editor.bundle.NLPluginBundleGroupStrategy;
import org.eclipse.babel.editor.preferences.MsgEditorPreferences;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorSite;

public final class MessagesBundleGroupFactory {
    private static final String BUNDLE_NAME = "Bundle-SymbolicName:";
    private static final String FRAG_HOST = "Fragment-Host:";
    private static final IProject[] EMPTY_PROJECTS = new IProject[0];

    private MessagesBundleGroupFactory() {
    }

    public static MessagesBundleGroup createBundleGroup(IEditorSite site, IFile file) {
        if (!MsgEditorPreferences.getNLSupportEnabled()) {
            return MessagesBundleGroupFactory.createDefaultBundleGroup(site, file);
        }
        IProject proj = file.getProject();
        try {
            if (proj == null || !proj.hasNature("org.eclipse.pde.PluginNature")) {
                return MessagesBundleGroupFactory.createDefaultBundleGroup(site, file);
            }
        }
        catch (CoreException coreException) {}
        IFolder nl = MessagesBundleGroupFactory.getNLFolder(file);
        String hostId = MessagesBundleGroupFactory.getHostPluginId((IResource)file);
        if (hostId != null) {
            return new MessagesBundleGroup(new NLFragmentBundleGroupStrategy(site, file, hostId, nl));
        }
        if (site == null) {
            return new MessagesBundleGroup(new NLPluginBundleGroupStrategy(site, file, nl));
        }
        IProject[] frags = MessagesBundleGroupFactory.collectTargetingFragments(file);
        if (frags != null) {
            return new MessagesBundleGroup(new NLPluginBundleGroupStrategy(site, file, nl, frags));
        }
        return new MessagesBundleGroup(new NLPluginBundleGroupStrategy(site, file, nl));
    }

    private static MessagesBundleGroup createDefaultBundleGroup(IEditorSite site, IFile file) {
        return new MessagesBundleGroup(new DefaultBundleGroupStrategy(site, file));
    }

    static String getHostPluginId(IResource file) {
        return MessagesBundleGroupFactory.getPDEManifestAttribute(file, FRAG_HOST);
    }

    static String getBundleId(IResource file) {
        return MessagesBundleGroupFactory.getPDEManifestAttribute(file, BUNDLE_NAME);
    }

    /*
     * Exception decompiling
     */
    static String getPDEManifestAttribute(IResource openedFile, String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static IFolder getNLFolder(IFile openedFile) {
        IContainer cont = openedFile.getParent();
        while (cont != null) {
            if (cont.getParent() != null && cont.getParent().getType() == 4) {
                if (cont.getName().equals("nl")) {
                    return (IFolder)cont;
                }
                return null;
            }
            cont = cont.getParent();
        }
        return null;
    }

    protected static IProject[] collectTargetingFragments(IFile openedFile) {
        IProject thisProject = openedFile.getProject();
        if (thisProject == null) {
            return null;
        }
        ArrayList<IProject> projs = null;
        String bundleId = MessagesBundleGroupFactory.getBundleId((IResource)openedFile);
        try {
            IResource[] members = thisProject.getParent().members();
            int i = 0;
            while (i < members.length) {
                String hostId;
                IResource childRes = members[i];
                if (childRes != thisProject && childRes.getType() == 4 && bundleId.equals(hostId = MessagesBundleGroupFactory.getHostPluginId(childRes))) {
                    if (projs == null) {
                        projs = new ArrayList<IProject>();
                    }
                    projs.add((IProject)childRes);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return projs == null ? null : projs.toArray(EMPTY_PROJECTS);
    }
}

