/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.bundle;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.babel.core.message.internal.MessagesBundle;
import org.eclipse.babel.core.message.resource.internal.PropertiesIFileResource;
import org.eclipse.babel.core.message.resource.internal.PropertiesReadOnlyResource;
import org.eclipse.babel.core.message.resource.ser.PropertiesDeserializer;
import org.eclipse.babel.core.message.resource.ser.PropertiesSerializer;
import org.eclipse.babel.editor.bundle.MessagesBundleGroupFactory;
import org.eclipse.babel.editor.bundle.NLPluginBundleGroupStrategy;
import org.eclipse.babel.editor.plugin.MessagesEditorPlugin;
import org.eclipse.babel.editor.preferences.MsgEditorPreferences;
import org.eclipse.babel.editor.resource.EclipsePropertiesEditorResource;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class NLFragmentBundleGroupStrategy
extends NLPluginBundleGroupStrategy {
    private final String _fragmentHostID;
    private boolean hostPluginInWorkspaceWasLookedFor = false;
    private IProject hostPluginInWorkspace;

    public NLFragmentBundleGroupStrategy(IEditorSite site, IFile file, String fragmentHostID, IFolder nlFolder) {
        super(site, file, nlFolder);
        this._fragmentHostID = fragmentHostID;
    }

    @Override
    public MessagesBundle[] loadMessagesBundles() {
        MessagesBundle[] defaultFiles = super.loadMessagesBundles();
        int i = 0;
        while (i < defaultFiles.length) {
            MessagesBundle mb = defaultFiles[i];
            if (UIUtils.ROOT_LOCALE.equals(mb.getLocale()) || mb.getLocale() == null) {
                return defaultFiles;
            }
            ++i;
        }
        try {
            MessagesBundle locatedBaseProperties = this.loadDefaultMessagesBundle();
            if (locatedBaseProperties != null) {
                MessagesBundle[] result = new MessagesBundle[defaultFiles.length + 1];
                result[0] = locatedBaseProperties;
                System.arraycopy(defaultFiles, 0, result, 1, defaultFiles.length);
                return result;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public MessagesBundle createMessagesBundle(Locale locale) {
        return super.createMessagesBundle(locale);
    }

    @Override
    public String createMessagesBundleGroupName() {
        return super.createMessagesBundleGroupName();
    }

    private MessagesBundle loadDefaultMessagesBundle() throws IOException, CoreException {
        Object newEditorInput = null;
        IPath propertiesBasePath = this.getPropertiesPath();
        String resourceLocationLabel = null;
        IProject developpedProject = this.getHostPluginProjectDevelopedInWorkspace();
        if (developpedProject != null) {
            String[] jarredProps;
            IFile file = this.getPropertiesFile(developpedProject, propertiesBasePath);
            if (!file.exists() && (jarredProps = this.getJarredPropertiesAndResourceLocationLabel(developpedProject, propertiesBasePath)) != null) {
                if (this.site == null) {
                    return new MessagesBundle(new PropertiesReadOnlyResource(UIUtils.ROOT_LOCALE, new PropertiesSerializer(MsgEditorPreferences.getSerializerConfig()), new PropertiesDeserializer(MsgEditorPreferences.getDeserializerConfig()), jarredProps[0], jarredProps[1]));
                }
                newEditorInput = new DummyEditorInput(jarredProps[0], this.getPropertiesPath().lastSegment(), jarredProps[1]);
                resourceLocationLabel = jarredProps[1];
            }
            if (this.site == null) {
                if (file.exists()) {
                    return new MessagesBundle(new PropertiesIFileResource(UIUtils.ROOT_LOCALE, new PropertiesSerializer(MsgEditorPreferences.getSerializerConfig()), new PropertiesDeserializer(MsgEditorPreferences.getDeserializerConfig()), file, MessagesEditorPlugin.getDefault()));
                }
                return null;
            }
            if (file.exists()) {
                newEditorInput = new FileEditorInput(file);
            }
        }
        if (newEditorInput == null) {
            InputStream in;
            block28: {
                String contents;
                block29: {
                    MessagesBundle messagesBundle;
                    block30: {
                        in = null;
                        String resourceName = null;
                        try {
                            Bundle bundle = Platform.getBundle((String)this._fragmentHostID);
                            if (bundle != null) {
                                resourceName = propertiesBasePath.toString();
                                URL url = bundle.getEntry(resourceName);
                                if (url != null) {
                                    in = url.openStream();
                                    resourceLocationLabel = url.toExternalForm();
                                } else {
                                    url = bundle.getResource(resourceName);
                                    if (url != null) {
                                        in = url.openStream();
                                        resourceLocationLabel = url.toExternalForm();
                                    }
                                }
                            }
                            if (in == null) break block28;
                            contents = this.getContents(in);
                            if (this.site != null) break block29;
                            messagesBundle = new MessagesBundle(new PropertiesReadOnlyResource(UIUtils.ROOT_LOCALE, new PropertiesSerializer(MsgEditorPreferences.getSerializerConfig()), new PropertiesDeserializer(MsgEditorPreferences.getDeserializerConfig()), contents, resourceLocationLabel));
                            if (in == null) break block30;
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return messagesBundle;
                }
                newEditorInput = new DummyEditorInput(contents, this.getPropertiesPath().lastSegment(), this.getPropertiesPath().toString());
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (newEditorInput != null) {
            TextEditor textEditor = null;
            if (this.site != null) {
                try {
                    textEditor = (TextEditor)Class.forName("org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditor").newInstance();
                }
                catch (Exception exception) {
                    textEditor = new TextEditor();
                }
                textEditor.init(this.site, (IEditorInput)newEditorInput);
            } else {
                System.err.println("the site " + this.site);
            }
            EclipsePropertiesEditorResource readOnly = new EclipsePropertiesEditorResource(UIUtils.ROOT_LOCALE, new PropertiesSerializer(MsgEditorPreferences.getSerializerConfig()), new PropertiesDeserializer(MsgEditorPreferences.getDeserializerConfig()), textEditor);
            if (resourceLocationLabel != null) {
                readOnly.setResourceLocationLabel(resourceLocationLabel);
            }
            return new MessagesBundle(readOnly);
        }
        return null;
    }

    private String getContents(InputStream in) throws IOException {
        int ch;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer buffer = new StringBuffer();
        while ((ch = ((Reader)reader).read()) > -1) {
            buffer.append((char)ch);
        }
        in.close();
        return buffer.toString();
    }

    protected boolean resourceBundleIsInsideClasses() {
        IProject thisProj = this.getOpenedFile().getProject();
        Collection<String> srcs = NLFragmentBundleGroupStrategy.getSourceFolderPathes(thisProj);
        String thisPath = this.getOpenedFile().getProjectRelativePath().toString();
        if (srcs != null) {
            for (String srcPath : srcs) {
                if (!thisPath.startsWith(srcPath)) continue;
                return true;
            }
        }
        return false;
    }

    protected IPath getPropertiesPath() {
        Path projRelative = this.basePathInsideNL == null ? super.getOpenedFile().getParent().getProjectRelativePath() : new Path(this.basePathInsideNL);
        return this.removePathToSourceFolder((IPath)projRelative).append(String.valueOf(this.getBaseName()) + ".properties");
    }

    protected IFile getPropertiesFile(IProject hostPluginProject, IPath propertiesBasePath) {
        IResource r = hostPluginProject.findMember(propertiesBasePath);
        if (r != null && r.getType() == 1) {
            return (IFile)r;
        }
        Collection<String> srcPathes = NLFragmentBundleGroupStrategy.getSourceFolderPathes(hostPluginProject);
        if (srcPathes != null) {
            for (String srcPath : srcPathes) {
                IFolder srcFolder = hostPluginProject.getFolder((IPath)new Path(srcPath));
                if (!srcFolder.exists() || (r = srcFolder.findMember(propertiesBasePath)) == null || r.getType() != 1) continue;
                return (IFile)r;
            }
        }
        return hostPluginProject.getFile(propertiesBasePath);
    }

    /*
     * Loose catch block
     */
    private String[] getJarredPropertiesAndResourceLocationLabel(IProject hostPluginProject, IPath propertiesBasePath) {
        Collection<String> libPathes = this.getLibPathes(hostPluginProject);
        if (libPathes != null) {
            String entryName = propertiesBasePath.toString();
            for (String libPath : libPathes) {
                JarFile jf;
                block15: {
                    String[] stringArray;
                    block16: {
                        File file;
                        IFile jar;
                        if (!libPath.endsWith(".jar") || !(jar = hostPluginProject.getFile((IPath)new Path(libPath))).exists() || !(file = jar.getRawLocation().toFile()).exists()) continue;
                        jf = null;
                        jf = new JarFile(file);
                        JarEntry je = jf.getJarEntry(entryName);
                        if (je == null) break block15;
                        String content = this.getContents(jf.getInputStream(je));
                        String location = String.valueOf(jar.getFullPath().toString()) + "!/" + entryName;
                        stringArray = new String[]{content, location};
                        if (jf == null) break block16;
                        try {
                            jf.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return stringArray;
                    catch (IOException iOException) {
                        try {
                            if (jf == null) continue;
                        }
                        catch (Throwable throwable) {
                            if (jf != null) {
                                try {
                                    jf.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            throw throwable;
                        }
                        try {
                            jf.close();
                        }
                        catch (IOException iOException3) {}
                        continue;
                    }
                }
                if (jf == null) continue;
                try {
                    jf.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected static Collection<String> getSourceFolderPathes(IProject proj) {
        return NLFragmentBundleGroupStrategy.getClasspathEntryPathes(proj, "src");
    }

    protected Collection<String> getLibPathes(IProject proj) {
        return NLFragmentBundleGroupStrategy.getClasspathEntryPathes(proj, "lib");
    }

    protected static Collection<String> getClasspathEntryPathes(IProject proj, String classpathentryKind) {
        ArrayList<String> res;
        block17: {
            IFile classpathRes = proj.getFile(".classpath");
            if (!classpathRes.exists()) {
                return null;
            }
            res = new ArrayList<String>();
            InputStream in = null;
            try {
                try {
                    in = classpathRes.getContents();
                    InputStreamReader r = new InputStreamReader(in, "UTF-8");
                    LineNumberReader lnr = new LineNumberReader(r);
                    String line = lnr.readLine();
                    while (line != null) {
                        int secondQuoteIndex;
                        int pathIndex;
                        if (line.indexOf("<classpathentry ") != -1 && line.indexOf(" kind=\"" + classpathentryKind + "\" ") != -1 && (pathIndex = line.indexOf(" path=\"")) != -1 && (secondQuoteIndex = line.indexOf(34, pathIndex + " path=\"".length())) != -1) {
                            res.add(line.substring(pathIndex + " path=\"".length(), secondQuoteIndex));
                        }
                        line = lnr.readLine();
                    }
                    lnr.close();
                    ((Reader)r).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return res;
    }

    @Override
    protected boolean isExistingFirstFolderForDefaultLocale(String folderName) {
        IProject thisProject = this.getOpenedFile().getProject();
        if (thisProject == null) {
            return false;
        }
        boolean res = thisProject.getFolder(folderName).exists();
        if (res) {
            return true;
        }
        IProject developpedProject = this.getHostPluginProjectDevelopedInWorkspace();
        if (developpedProject != null) {
            res = developpedProject.getFolder(folderName).exists();
            return res;
        }
        Bundle bundle = this.getHostPluginBundleInPlatform();
        return bundle != null && bundle.getEntry(folderName) != null;
    }

    private IProject getHostPluginProjectDevelopedInWorkspace() {
        if (this.hostPluginInWorkspaceWasLookedFor) {
            return this.hostPluginInWorkspace;
        }
        this.hostPluginInWorkspaceWasLookedFor = true;
        IProject thisProject = this.getOpenedFile().getProject();
        if (thisProject == null) {
            return null;
        }
        try {
            IResource[] members = thisProject.getParent().members();
            int i = 0;
            while (i < members.length) {
                String bundle;
                IResource childRes = members[i];
                if (childRes != thisProject && childRes.getType() == 4 && this._fragmentHostID.equals(bundle = MessagesBundleGroupFactory.getBundleId(childRes))) {
                    this.hostPluginInWorkspace = (IProject)childRes;
                    return this.hostPluginInWorkspace;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private Bundle getHostPluginBundleInPlatform() {
        Bundle bundle = Platform.getBundle((String)this._fragmentHostID);
        if (bundle != null) {
            return bundle;
        }
        return null;
    }

    private class DummyEditorInput
    implements IStorageEditorInput,
    IStorage {
        private String _contents;
        private String _name;
        private String _toolTipText;

        public DummyEditorInput(String contents, String name, boolean isEditable) {
            this(contents, name, name);
        }

        public DummyEditorInput(String contents, String name, String tipText) {
            this._contents = contents;
            this._name = name;
            this._toolTipText = tipText;
        }

        public IStorage getStorage() throws CoreException {
            return this;
        }

        public boolean exists() {
            return false;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this._name;
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this._toolTipText;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this._contents.getBytes());
        }

        public IPath getFullPath() {
            return null;
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

