/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.babel.editor.i18n.AbstractI18NEntry;
import org.eclipse.babel.editor.i18n.actions.FoldingAction;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.babel.editor.widgets.ActionButton;
import org.eclipse.babel.messages.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class EntryLeftBanner
extends Composite {
    private static final String FONT_LINK_KEY = "linkFont";

    public EntryLeftBanner(Composite parent, final AbstractI18NEntry i18NEntry) {
        super(parent, 0);
        RowLayout layout = new RowLayout();
        this.setLayout((Layout)layout);
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        FoldingAction foldAction = new FoldingAction(i18NEntry);
        new ActionButton(this, (IAction)foldAction);
        Link localeLabel = new Link((Composite)this, 0);
        localeLabel.setFont(UIUtils.createFont(FONT_LINK_KEY, (Control)localeLabel, 1));
        boolean isEditable = i18NEntry.isEditable();
        localeLabel.setText("<a>" + UIUtils.getDisplayName(i18NEntry.getLocale()) + "</a>" + (!isEditable ? " (" + Messages.editor_readOnly + ")" : ""));
        localeLabel.setToolTipText(MessageFormat.format(Messages.editor_i18nentry_resourcelocation, i18NEntry.getResourceLocationLabel()));
        localeLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                i18NEntry.getResourceBundleEditor().setActivePage(i18NEntry.getLocale());
            }
        });
        Image countryIcon = this.loadCountryIcon(i18NEntry.getLocale());
        if (countryIcon != null) {
            Label imgLabel = new Label((Composite)this, 0);
            imgLabel.setImage(countryIcon);
        }
    }

    private Image loadCountryIcon(Locale countryLocale) {
        Image image = null;
        String countryCode = null;
        if (countryLocale != null && countryLocale.getCountry() != null) {
            countryCode = countryLocale.getCountry().toLowerCase();
        }
        if (countryCode != null && countryCode.length() > 0) {
            String imageName = "countries/" + countryCode.toLowerCase() + ".gif";
            image = UIUtils.getImage(imageName);
        }
        return image;
    }
}

