/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.i18n.actions;

import java.util.Locale;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ShowSimilarAction
extends Action {
    private final String[] keys;
    private final String key;
    private final Locale locale;

    public ShowSimilarAction(String[] keys, String key, Locale locale) {
        this.keys = keys;
        this.key = key;
        this.locale = locale;
        this.setText("Show similar keys.");
        this.setImageDescriptor(UIUtils.getImageDescriptor("similar.gif"));
        this.setToolTipText("Show similar keys.");
    }

    public void run() {
        StringBuffer buf = new StringBuffer("\"" + this.key + "\" (" + UIUtils.getDisplayName(this.locale) + ") has similar " + "value as the following key(s): \n\n");
        int i = 0;
        while (i < this.keys.length) {
            String similarKey = this.keys[i];
            if (!this.key.equals(similarKey)) {
                buf.append("    \ufffd ");
                buf.append(similarKey);
                buf.append(" (" + UIUtils.getDisplayName(this.locale) + ")");
                buf.append("\n");
            }
            ++i;
        }
        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Similar value", (String)buf.toString());
    }
}

