/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.babel.core.message.IMessagesBundle;
import org.eclipse.babel.core.message.internal.IMessagesBundleGroupListener;
import org.eclipse.babel.core.message.internal.MessageException;
import org.eclipse.babel.core.message.internal.MessagesBundle;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.message.manager.RBManager;
import org.eclipse.babel.core.message.resource.IMessagesResource;
import org.eclipse.babel.core.message.tree.internal.AbstractKeyTreeModel;
import org.eclipse.babel.editor.IMessagesEditor;
import org.eclipse.babel.editor.IMessagesEditorChangeListener;
import org.eclipse.babel.editor.builder.ToggleNatureAction;
import org.eclipse.babel.editor.bundle.MessagesBundleGroupFactory;
import org.eclipse.babel.editor.i18n.I18NPage;
import org.eclipse.babel.editor.internal.MessagesEditorMarkers;
import org.eclipse.babel.editor.resource.EclipsePropertiesEditorResource;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.babel.editor.views.MessagesBundleGroupOutline;
import org.eclipse.babel.messages.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AbstractMessagesEditor
extends MultiPageEditorPart
implements IGotoMarker,
IMessagesEditor {
    public static final String EDITOR_ID = "org.eclilpse.babel.editor.editor.MessagesEditor";
    protected String selectedKey;
    protected List<IMessagesEditorChangeListener> changeListeners = new ArrayList<IMessagesEditorChangeListener>(2);
    protected MessagesBundleGroup messagesBundleGroup;
    protected I18NPage i18nPage;
    protected final List<Locale> localesIndex = new ArrayList<Locale>();
    protected final List<ITextEditor> textEditorsIndex = new ArrayList<ITextEditor>();
    protected MessagesBundleGroupOutline outline = new MessagesBundleGroupOutline(this);
    protected MessagesEditorMarkers markers;
    protected AbstractKeyTreeModel keyTreeModel;
    protected IFile file;
    protected boolean updateSelectedKey;
    private int showOnlyMissingAndUnusedKeys = 0;

    public MessagesEditorMarkers getMarkers() {
        return this.markers;
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        this.file = null;
        if (editorInput instanceof IFileEditorInput) {
            this.file = ((IFileEditorInput)editorInput).getFile();
            IProject p = this.file.getProject();
            if (p != null && p.isAccessible()) {
                ToggleNatureAction.addOrRemoveNatureOnProject(p, true, true);
            }
        } else if (editorInput instanceof FileStoreEditorInput) {
            FileStoreEditorInput input = (FileStoreEditorInput)editorInput;
            this.file = this.createLinkedResource(input.getURI().getRawPath());
        }
        if (this.file != null) {
            try {
                this.messagesBundleGroup = MessagesBundleGroupFactory.createBundleGroup(site, this.file);
            }
            catch (MessageException e) {
                throw new PartInitException("Cannot create bundle group.", (Throwable)e);
            }
        } else {
            throw new PartInitException("Unable to load the selected file");
        }
        this.messagesBundleGroup.addMessagesBundleGroupListener(this.getMsgBundleGroupListner());
        this.markers = new MessagesEditorMarkers(this.messagesBundleGroup);
        this.setPartName(this.messagesBundleGroup.getName());
        this.setTitleImage(UIUtils.getImage("resourcebundle.gif"));
        this.closeIfAreadyOpen(site, this.file);
        super.init(site, editorInput);
        this.keyTreeModel = new AbstractKeyTreeModel(this.messagesBundleGroup);
        this.initRAP();
    }

    private IFile createLinkedResource(String fileName) {
        IFile file = null;
        try {
            Path location;
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IProject project = ws.getRoot().getProject("External Files");
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            if ((file = project.getFile((location = new Path(fileName)).lastSegment())).exists()) {
                file.delete(true, null);
            }
            file.createLink((IPath)location, 0, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            file = null;
        }
        return file;
    }

    protected void createPages() {
        this.i18nPage = new I18NPage(this.getContainer(), 0, this);
        int index = this.addPage((Control)this.i18nPage);
        this.setPageText(index, Messages.editor_properties);
        this.setPageImage(index, UIUtils.getImage("resourcebundle.gif"));
        Locale[] locales = this.messagesBundleGroup.getLocales();
        UIUtils.sortLocales(locales);
        locales = UIUtils.filterLocales(locales);
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            MessagesBundle messagesBundle = (MessagesBundle)this.messagesBundleGroup.getMessagesBundle(locale);
            this.createMessagesBundlePage(messagesBundle);
            ++i;
        }
    }

    protected void createMessagesBundlePage(MessagesBundle messagesBundle) {
        try {
            IMessagesResource resource = messagesBundle.getResource();
            TextEditor textEditor = (TextEditor)resource.getSource();
            int index = this.addPage((IEditorPart)textEditor, textEditor.getEditorInput());
            this.setPageText(index, UIUtils.getDisplayName(messagesBundle.getLocale()));
            this.setPageImage(index, UIUtils.getImage("propertiesfile.gif"));
            this.localesIndex.add(messagesBundle.getLocale());
            this.textEditorsIndex.add((ITextEditor)textEditor);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating text editor page.", null, (IStatus)e.getStatus());
        }
    }

    protected void addMessagesBundle(MessagesBundle messagesBundle) {
        this.createMessagesBundlePage(messagesBundle);
        this.i18nPage.addI18NEntry(messagesBundle.getLocale());
    }

    protected void removeMessagesBundle(MessagesBundle messagesBundle) {
        IMessagesResource resource = messagesBundle.getResource();
        TextEditor textEditor = (TextEditor)resource.getSource();
        int pageIndex = this.textEditorsIndex.indexOf(textEditor) + 1;
        this.removePage(pageIndex);
        this.textEditorsIndex.remove(textEditor);
        this.localesIndex.remove(messagesBundle.getLocale());
        textEditor.dispose();
        this.i18nPage.removeI18NEntry(messagesBundle.getLocale());
    }

    public void reloadDisplayedContents(boolean showFirstPage) {
        super.removePage(0);
        int currentlyActivePage = 0;
        if (!showFirstPage) {
            currentlyActivePage = super.getActivePage();
        }
        this.changeListeners.clear();
        this.i18nPage.dispose();
        this.i18nPage = new I18NPage(this.getContainer(), 0, this);
        super.addPage(0, (Control)this.i18nPage);
        this.setPageText(0, Messages.editor_properties);
        this.setPageImage(0, UIUtils.getImage("resourcebundle.gif"));
        if (currentlyActivePage == 0) {
            super.setActivePage(currentlyActivePage);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        for (ITextEditor textEditor : this.textEditorsIndex) {
            textEditor.doSave(monitor);
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.updateSelectedKey = true;
        RBManager instance = RBManager.getInstance(this.messagesBundleGroup.getProjectName());
        this.refreshKeyTreeModel();
        instance.fireEditorSaved();
    }

    protected void refreshKeyTreeModel() {
        String selectedKey = this.getSelectedKey();
        if (this.messagesBundleGroup == null) {
            this.messagesBundleGroup = MessagesBundleGroupFactory.createBundleGroup((IEditorSite)this.getSite(), this.file);
        }
        AbstractKeyTreeModel oldModel = this.keyTreeModel;
        this.keyTreeModel = new AbstractKeyTreeModel(this.messagesBundleGroup);
        for (IMessagesEditorChangeListener listener : this.changeListeners) {
            listener.keyTreeModelChanged(oldModel, this.keyTreeModel);
        }
        this.i18nPage.getTreeViewer().expandAll();
        if (selectedKey != null) {
            this.setSelectedKey(selectedKey);
        }
    }

    public void updateBundleGroup() {
        this.messagesBundleGroup = MessagesBundleGroupFactory.createBundleGroup((IEditorSite)this.getSite(), this.file);
        AbstractKeyTreeModel oldModel = this.keyTreeModel;
        this.keyTreeModel = new AbstractKeyTreeModel(this.messagesBundleGroup);
        this.markers = new MessagesEditorMarkers(this.messagesBundleGroup);
        for (IMessagesEditorChangeListener listener : this.changeListeners) {
            listener.keyTreeModelChanged(oldModel, this.keyTreeModel);
        }
        this.i18nPage.getTreeViewer().expandAll();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setActivePage(Locale locale) {
        int index = this.localesIndex.indexOf(locale);
        if (index > -1) {
            this.setActivePage(index + 1);
        }
    }

    public void gotoMarker(IMarker marker) {
        IResource resource = marker.getResource();
        Locale[] locales = this.messagesBundleGroup.getLocales();
        int i = 0;
        while (i < locales.length) {
            EclipsePropertiesEditorResource propFile;
            IMessagesResource messagesResource = ((MessagesBundle)this.messagesBundleGroup.getMessagesBundle(locales[i])).getResource();
            if (messagesResource instanceof EclipsePropertiesEditorResource && resource.equals((Object)(propFile = (EclipsePropertiesEditorResource)messagesResource).getResource())) {
                try {
                    String key = (String)marker.getAttribute("location");
                    if (key != null && key.length() > 0) {
                        this.getI18NPage().selectLocale(locales[i]);
                        this.setActivePage(0);
                        this.setSelectedKey(key);
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.setActivePage(locales[i]);
                IDE.gotoMarker((IEditorPart)((IEditorPart)propFile.getSource()), (IMarker)marker);
                break;
            }
            ++i;
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex != 0) {
            this.setSelection(newPageIndex);
        } else if (newPageIndex == 0 && this.updateSelectedKey) {
            for (IMessagesBundle bundle : this.messagesBundleGroup.getMessagesBundles()) {
                RBManager.getInstance(this.messagesBundleGroup.getProjectName()).fireResourceChanged(bundle);
            }
            this.updateSelectedKey = false;
        }
    }

    protected void setSelection(int newPageIndex) {
        ITextEditor editor = this.textEditorsIndex.get(--newPageIndex);
        String selectedKey = this.getSelectedKey();
        if (selectedKey != null && editor.getEditorInput() instanceof FileEditorInput) {
            FileEditorInput input = (FileEditorInput)editor.getEditorInput();
            try {
                IFile file = input.getFile();
                file.refreshLocal(0, null);
                BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents()));
                String line = "";
                int selectionIndex = 0;
                boolean found = false;
                while ((line = reader.readLine()) != null) {
                    int index = line.indexOf(61);
                    if (index != -1 && selectedKey.equals(line.substring(0, index).trim())) {
                        found = true;
                        break;
                    }
                    selectionIndex += line.length() + 2;
                }
                if (found) {
                    editor.selectAndReveal(selectionIndex, 0);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isBundleMember(IFile file) {
        return false;
    }

    protected void closeIfAreadyOpen(IEditorSite site, IFile file) {
        IWorkbenchPage[] pages = site.getWorkbenchWindow().getPages();
        int i = 0;
        while (i < pages.length) {
            IWorkbenchPage page = pages[i];
            IEditorReference[] editors = page.getEditorReferences();
            int j = 0;
            while (j < editors.length) {
                AbstractMessagesEditor rbe;
                IEditorPart editor = editors[j].getEditor(false);
                if (editor instanceof AbstractMessagesEditor && (rbe = (AbstractMessagesEditor)editor).isBundleMember(file)) {
                    page.closeEditor(editor, true);
                }
                ++j;
            }
            ++i;
        }
    }

    public void dispose() {
        for (IMessagesEditorChangeListener listener : this.changeListeners) {
            listener.editorDisposed();
        }
        if (this.i18nPage != null) {
            this.i18nPage.dispose();
        }
        for (ITextEditor textEditor : this.textEditorsIndex) {
            textEditor.dispose();
        }
        this.disposeRAP();
    }

    @Override
    public String getSelectedKey() {
        return this.selectedKey;
    }

    @Override
    public void setSelectedKey(String activeKey) {
        if (this.selectedKey == null && activeKey != null || this.selectedKey != null && activeKey == null || this.selectedKey != null && !this.selectedKey.equals(activeKey)) {
            String oldKey = this.selectedKey;
            this.selectedKey = activeKey;
            for (IMessagesEditorChangeListener listener : this.changeListeners) {
                listener.selectedKeyChanged(oldKey, activeKey);
            }
        }
    }

    public void addChangeListener(IMessagesEditorChangeListener listener) {
        this.changeListeners.add(0, listener);
    }

    public void removeChangeListener(IMessagesEditorChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public Collection<IMessagesEditorChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    @Override
    public MessagesBundleGroup getBundleGroup() {
        return this.messagesBundleGroup;
    }

    public AbstractKeyTreeModel getKeyTreeModel() {
        return this.keyTreeModel;
    }

    public void setKeyTreeModel(AbstractKeyTreeModel newKeyTreeModel) {
        if (this.keyTreeModel == null && newKeyTreeModel != null || this.keyTreeModel != null && newKeyTreeModel == null || !this.keyTreeModel.equals(newKeyTreeModel)) {
            AbstractKeyTreeModel oldModel = this.keyTreeModel;
            this.keyTreeModel = newKeyTreeModel;
            for (IMessagesEditorChangeListener listener : this.changeListeners) {
                listener.keyTreeModelChanged(oldModel, newKeyTreeModel);
            }
        }
    }

    public I18NPage getI18NPage() {
        return this.i18nPage;
    }

    public int isShowOnlyUnusedAndMissingKeys() {
        return this.showOnlyMissingAndUnusedKeys;
    }

    public void setShowOnlyUnusedMissingKeys(int showFlag) {
        this.showOnlyMissingAndUnusedKeys = showFlag;
        for (IMessagesEditorChangeListener listener : this.getChangeListeners()) {
            listener.showOnlyUnusedAndMissingChanged(showFlag);
        }
    }

    public Object getAdapter(Class adapter) {
        if (IFile.class.equals((Object)adapter)) {
            ArrayList<IFile> result = new ArrayList<IFile>();
            for (ITextEditor editor : this.textEditorsIndex) {
                IEditorInput editorInput = editor.getEditorInput();
                if (!(editorInput instanceof FileEditorInput)) continue;
                result.add(((FileEditorInput)editorInput).getFile());
            }
            return result;
        }
        Object obj = super.getAdapter(adapter);
        if (obj == null && IContentOutlinePage.class.equals((Object)adapter)) {
            return this.outline;
        }
        return obj;
    }

    public ITextEditor getTextEditor(Locale locale) {
        int index = this.localesIndex.indexOf(locale);
        return this.textEditorsIndex.get(index);
    }

    public Image getTitleImage() {
        return UIUtils.getImageDescriptor("resourcebundle.gif").createImage();
    }

    @Override
    public void setTitleName(String name) {
        this.setPartName(name);
    }

    @Override
    public abstract void setEnabled(boolean var1);

    protected abstract void initRAP();

    protected abstract void disposeRAP();

    protected abstract IMessagesBundleGroupListener getMsgBundleGroupListner();
}

