/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.internal;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import org.eclipse.babel.core.message.checks.IMessageCheck;
import org.eclipse.babel.core.message.checks.internal.DuplicateValueCheck;
import org.eclipse.babel.core.message.checks.internal.MissingValueCheck;
import org.eclipse.babel.core.message.internal.MessagesBundle;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.message.internal.MessagesBundleGroupAdapter;
import org.eclipse.babel.editor.resource.validator.IValidationMarkerStrategy;
import org.eclipse.babel.editor.resource.validator.MessagesBundleGroupValidator;
import org.eclipse.babel.editor.resource.validator.ValidationFailureEvent;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.swt.widgets.Display;

public class MessagesEditorMarkers
extends Observable
implements IValidationMarkerStrategy {
    private final MessagesBundleGroup messagesBundleGroup;
    private Map<String, Collection<IMessageCheck>> markersIndex = new HashMap<String, Collection<IMessageCheck>>();
    private Map<String, Collection<IMessageCheck>> localizedMarkersMap = new HashMap<String, Collection<IMessageCheck>>();

    public MessagesEditorMarkers(MessagesBundleGroup messagesBundleGroup) {
        this.messagesBundleGroup = messagesBundleGroup;
        this.validate();
        messagesBundleGroup.addMessagesBundleGroupListener(new MessagesBundleGroupAdapter(){

            @Override
            public void messageChanged(MessagesBundle messagesBundle, PropertyChangeEvent changeEvent) {
                this.resetMarkers();
            }

            @Override
            public void messagesBundleChanged(MessagesBundle messagesBundle, PropertyChangeEvent changeEvent) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        this.resetMarkers();
                    }
                });
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.resetMarkers();
            }

            private void resetMarkers() {
                MessagesEditorMarkers.this.clear();
                MessagesEditorMarkers.this.validate();
            }
        });
    }

    private String buildLocalizedKey(Locale locale, String key) {
        if (locale == null) {
            locale = UIUtils.ROOT_LOCALE;
        }
        return locale + "=" + key;
    }

    @Override
    public void markFailed(ValidationFailureEvent event) {
        Collection<IMessageCheck> markersForKey = this.markersIndex.get(event.getKey());
        if (markersForKey == null) {
            markersForKey = new HashSet<IMessageCheck>();
            this.markersIndex.put(event.getKey(), markersForKey);
        }
        markersForKey.add(event.getCheck());
        String localizedKey = this.buildLocalizedKey(event.getLocale(), event.getKey());
        markersForKey = this.localizedMarkersMap.get(localizedKey);
        if (markersForKey == null) {
            markersForKey = new HashSet<IMessageCheck>();
            this.localizedMarkersMap.put(localizedKey, markersForKey);
        }
        markersForKey.add(event.getCheck());
        this.setChanged();
    }

    public void clear() {
        this.markersIndex.clear();
        this.localizedMarkersMap.clear();
        this.setChanged();
        this.notifyObservers(this);
    }

    public boolean isMarked(String key) {
        return this.markersIndex.containsKey(key);
    }

    public Collection<IMessageCheck> getFailedChecks(String key) {
        return this.markersIndex.get(key);
    }

    public Collection<IMessageCheck> getFailedChecks(String key, Locale locale) {
        return this.localizedMarkersMap.get(this.buildLocalizedKey(locale, key));
    }

    private void validate() {
        Locale[] locales = this.messagesBundleGroup.getLocales();
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            MessagesBundleGroupValidator.validate(this.messagesBundleGroup, locale, this);
            ++i;
        }
        this.notifyObservers(null);
    }

    public boolean isMissingOrUnusedKey(String key) {
        Collection<IMessageCheck> markers = this.getFailedChecks(key);
        return markers != null && this.markersContainMissing(markers);
    }

    public boolean isMissingKey(String key) {
        Collection<IMessageCheck> markers = this.getFailedChecks(key);
        return markers != null && this.markersContainMissing(markers);
    }

    public boolean isUnusedKey(String key, boolean isMissingOrUnused) {
        if (!isMissingOrUnused) {
            return false;
        }
        Collection<IMessageCheck> markers = this.getFailedChecks(key, UIUtils.ROOT_LOCALE);
        return markers != null && this.markersContainMissing(markers);
    }

    public boolean isDuplicateValue(String key) {
        Collection<IMessageCheck> markers = this.getFailedChecks(key);
        for (IMessageCheck marker : markers) {
            if (!(marker instanceof DuplicateValueCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean markersContainMissing(Collection<IMessageCheck> markers) {
        for (IMessageCheck marker : markers) {
            if (marker != MissingValueCheck.MISSING_KEY) continue;
            return true;
        }
        return false;
    }
}

