/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.internal;

import java.util.Locale;
import org.eclipse.babel.core.message.IMessagesBundle;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.util.FileUtils;
import org.eclipse.babel.editor.internal.MessagesEditor;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.babel.editor.widgets.LocaleSelector;
import org.eclipse.babel.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NewLocalePage
extends Composite {
    private static final String FONT_BOLD_BIG_KEY = "compositeFontBigBoldKey";
    private static final String FONT_BOLD_KEY = "compositeFontBoldKey";

    public NewLocalePage(Composite parent, final MessagesEditor editor) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        Composite block = new Composite((Composite)this, 0);
        block.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.verticalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        block.setLayoutData((Object)gridData);
        Label label = new Label(block, 0);
        label.setText(Messages.editor_new_title);
        label.setFont(UIUtils.createFont(FONT_BOLD_BIG_KEY, (Control)this, 1, 5));
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        label.setLayoutData((Object)gridData);
        final LocaleSelector localeSelector = new LocaleSelector(block);
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        localeSelector.setLayoutData(gridData);
        localeSelector.selectLocale(Locale.getDefault());
        Button createButton = new Button(block, 0);
        createButton.setText(Messages.editor_new_create);
        createButton.setFont(UIUtils.createFont(FONT_BOLD_KEY, (Control)this, 1, 1));
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        createButton.setLayoutData((Object)gridData);
        createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Locale[] locales;
                Locale newLocale = localeSelector.getSelectedLocale();
                MessagesBundleGroup bundleGroup = editor.getBundleGroup();
                boolean existsLocal = false;
                Locale[] localeArray = locales = bundleGroup.getLocales();
                int n = locales.length;
                int n2 = 0;
                while (n2 < n) {
                    Locale locale = localeArray[n2];
                    if (locale == null) {
                        if (newLocale == null) {
                            existsLocal = true;
                            break;
                        }
                    } else if (locale.equals(newLocale)) {
                        existsLocal = true;
                        break;
                    }
                    ++n2;
                }
                if (!existsLocal) {
                    IMessagesBundle source = !bundleGroup.getMessagesBundles().isEmpty() ? bundleGroup.getMessagesBundles().iterator().next() : null;
                    IMessagesBundle copy = bundleGroup.copyMessagesBundle(newLocale, source);
                    FileUtils.writeToFile(copy);
                    editor.reloadDisplayedContents(true);
                    editor.setSelectedKey(null);
                }
            }
        });
        this.layout();
    }
}

