/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.refactoring;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameKeyChange
extends Change {
    private final MessagesBundleGroup fMessagesBundleGroup;
    private final String fNewName;
    private final boolean fRenameChildKeys;
    private final KeyTreeNode fKeyTreeNode;
    private ChangeDescriptor fDescriptor;

    protected RenameKeyChange(MessagesBundleGroup messageBundleGroup, KeyTreeNode keyTreeNode, String newName, boolean renameChildKeys) {
        if (keyTreeNode == null || newName == null || newName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.fMessagesBundleGroup = messageBundleGroup;
        this.fKeyTreeNode = keyTreeNode;
        this.fNewName = newName;
        this.fRenameChildKeys = renameChildKeys;
        this.fDescriptor = null;
    }

    public ChangeDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    public String getName() {
        return MessageFormat.format("Rename {0} to {1}", this.fKeyTreeNode.getMessageKey(), this.fNewName);
    }

    public String getNewName() {
        return this.fNewName;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask("", 2);
        try {
            RefactoringStatus result;
            RefactoringStatus refactoringStatus = result = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public Object getModifiedElement() {
        return "what is this for?";
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("Rename resource bundle key", 1);
            KeyTreeNode root = (KeyTreeNode)this.fKeyTreeNode.getParent();
            while (root.getName() != null) {
                root = (KeyTreeNode)root.getParent();
            }
            if (this.fRenameChildKeys) {
                String key = this.fKeyTreeNode.getMessageKey();
                String keyPrefix = String.valueOf(this.fKeyTreeNode.getMessageKey()) + ".";
                Collection<KeyTreeNode> branchNodes = this.fKeyTreeNode.getBranch();
                for (KeyTreeNode branchNode : branchNodes) {
                    String oldKey = branchNode.getMessageKey();
                    if (!oldKey.equals(key) && !oldKey.startsWith(keyPrefix)) continue;
                    String newKey = String.valueOf(this.fNewName) + oldKey.substring(key.length());
                    this.fMessagesBundleGroup.renameMessageKeys(oldKey, newKey);
                }
            } else {
                this.fMessagesBundleGroup.renameMessageKeys(this.fKeyTreeNode.getMessageKey(), this.fNewName);
            }
            String oldName = this.fKeyTreeNode.getMessageKey();
            String[] segments = this.fNewName.split("\\.");
            KeyTreeNode renamedKey = root;
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                renamedKey = (KeyTreeNode)renamedKey.getChild(segment);
                ++n2;
            }
            assert (renamedKey != null);
            RenameKeyChange renameKeyChange = new RenameKeyChange(this.fMessagesBundleGroup, renamedKey, oldName, this.fRenameChildKeys);
            return renameKeyChange;
        }
        finally {
            pm.done();
        }
    }
}

