/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.refactoring;

import java.text.MessageFormat;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;
import org.eclipse.babel.editor.refactoring.RenameKeyArguments;
import org.eclipse.babel.editor.refactoring.RenameKeyChange;
import org.eclipse.babel.editor.refactoring.RenameKeyDescriptor;
import org.eclipse.babel.messages.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class RenameKeyProcessor
extends RenameProcessor {
    private KeyTreeNode fKeyNode;
    private MessagesBundleGroup fMessageBundleGroup;
    private String fNewResourceName;
    private boolean fRenameChildKeys;
    private RenameKeyArguments fRenameArguments;

    public RenameKeyProcessor(KeyTreeNode keyNode, MessagesBundleGroup messagesBundleGroup) {
        if (keyNode == null) {
            throw new IllegalArgumentException("key node must not be null");
        }
        this.fKeyNode = keyNode;
        this.fMessageBundleGroup = messagesBundleGroup;
        this.fRenameArguments = null;
        this.fRenameChildKeys = true;
        this.setNewResourceName(keyNode.getMessageKey());
    }

    public KeyTreeNode getNewKeyTreeNode() {
        return this.fKeyNode;
    }

    public String getNewResourceName() {
        return this.fNewResourceName;
    }

    public void setNewResourceName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fNewResourceName = newName;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            this.fRenameArguments = new RenameKeyArguments(this.getNewResourceName(), this.fRenameChildKeys, false);
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus validateNewElementName(String newName) {
        String[] parts;
        Assert.isNotNull((Object)newName);
        if (newName.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)"New name for key must be entered");
        }
        if (newName.startsWith(".")) {
            return RefactoringStatus.createFatalErrorStatus((String)"Key cannot start with a '.'");
        }
        if (newName.endsWith(".")) {
            return RefactoringStatus.createFatalErrorStatus((String)"Key cannot end with a '.'");
        }
        String[] stringArray = parts = newName.split("\\.");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.length() == 0) {
                return RefactoringStatus.createFatalErrorStatus((String)"Key cannot contain an empty part between two periods");
            }
            if (!part.matches("([A-Z]|[a-z]|[0-9])*")) {
                return RefactoringStatus.createFatalErrorStatus((String)"Key can contain only letters, digits, and periods");
            }
            ++n2;
        }
        if (this.fMessageBundleGroup.isMessageKey(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.dialog_error_exists);
        }
        return new RefactoringStatus();
    }

    protected RenameKeyDescriptor createDescriptor() {
        RenameKeyDescriptor descriptor = new RenameKeyDescriptor();
        descriptor.setDescription(MessageFormat.format("Rename resource bundle key ''{0}''", this.fKeyNode.getMessageKey()));
        descriptor.setComment(MessageFormat.format("Rename resource ''{0}'' to ''{1}''", this.fKeyNode.getMessageKey(), this.fNewResourceName));
        descriptor.setFlags(7);
        descriptor.setNewName(this.getNewResourceName());
        descriptor.setRenameChildKeys(this.fRenameChildKeys);
        return descriptor;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            RenameKeyChange change = new RenameKeyChange(this.fMessageBundleGroup, this.getNewKeyTreeNode(), this.fNewResourceName, this.fRenameChildKeys);
            change.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)this.createDescriptor()));
            RenameKeyChange renameKeyChange = change;
            return renameKeyChange;
        }
        finally {
            pm.done();
        }
    }

    public Object[] getElements() {
        return new Object[]{this.fKeyNode};
    }

    public String getIdentifier() {
        return "org.eclipse.babel.editor.refactoring.renameKeyProcessor";
    }

    public String getProcessorName() {
        return "Rename Resource Bundle Key";
    }

    public boolean isApplicable() {
        return this.fKeyNode != null;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return new RefactoringParticipant[0];
    }

    public boolean getRenameChildKeys() {
        return this.fRenameChildKeys;
    }

    public void setRenameChildKeys(boolean renameChildKeys) {
        this.fRenameChildKeys = renameChildKeys;
    }
}

