/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.nls.internal.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.babel.editor.plugin.MessagesEditorPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.pde.nls.internal.ui.parser.LocaleUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ConfigureColumnsDialog
extends Dialog {
    private ArrayList<ColumnField> fields = new ArrayList();
    private ArrayList<String> result = new ArrayList();
    private String[] initialValues;
    private Color errorColor;
    private Image clearImage;

    public ConfigureColumnsDialog(Shell parentShell, String[] initialValues) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.initialValues = initialValues;
    }

    public int open() {
        return super.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Configure Columns");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 3;
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText("Enter \"key\", \"default\" or locale (e.g. \"de\" or \"zh_TW\"):");
        label.setLayoutData((Object)GridDataFactory.fillDefaults().hint(300, -1).span(3, 1).create());
        this.fields.add(this.createLanguageField(composite, "Column &1:"));
        this.fields.add(this.createLanguageField(composite, "Column &2:"));
        this.fields.add(this.createLanguageField(composite, "Column &3:"));
        this.fields.add(this.createLanguageField(composite, "Column &4:"));
        if (this.initialValues != null) {
            int i = 0;
            while (i < 4 && i < this.initialValues.length) {
                this.fields.get((int)i).text.setText(this.initialValues[i]);
                ++i;
            }
        }
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigureColumnsDialog.this.validate();
            }
        };
        for (ColumnField field : this.fields) {
            field.text.addModifyListener(modifyListener);
        }
        this.errorColor = new Color((Device)Display.getCurrent(), 255, 127, 127);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.validate();
        return contents;
    }

    private ColumnField createLanguageField(Composite parent, String labelText) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(labelText);
        Text text = new Text(parent, 18436);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.clearImage == null) {
            this.clearImage = MessagesEditorPlugin.getImageDescriptor("elcl16/clear_co.gif").createImage();
        }
        ToolBar toolbar = new ToolBar(parent, 0x800000);
        ToolItem item = new ToolItem(toolbar, 8);
        item.setImage(this.clearImage);
        item.setToolTipText("Clear");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (ColumnField field : ConfigureColumnsDialog.this.fields) {
                    if (field.clearButton != e.widget) continue;
                    field.text.setText("");
                }
            }
        });
        ColumnField field = new ColumnField();
        field.text = text;
        field.clearButton = item;
        return field;
    }

    protected void okPressed() {
        for (ColumnField field : this.fields) {
            String text = field.text.getText().trim();
            if (text.length() <= 0) continue;
            this.result.add(text);
        }
        super.okPressed();
        this.errorColor.dispose();
        this.clearImage.dispose();
    }

    public String[] getResult() {
        return this.result.toArray(new String[this.result.size()]);
    }

    protected void validate() {
        boolean isValid = true;
        for (ColumnField field : this.fields) {
            String text = field.text.getText();
            if (text.equals("") || text.equals("key") || text.equals("default")) {
                field.text.setBackground(null);
                continue;
            }
            try {
                LocaleUtil.parseLocale(text);
                field.text.setBackground(null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                field.text.setBackground(this.errorColor);
                isValid = false;
            }
        }
        Button okButton = this.getButton(0);
        okButton.setEnabled(isValid);
    }

    private class ColumnField {
        Text text;
        ToolItem clearButton;

        private ColumnField() {
        }
    }
}

