/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.nls.internal.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.nls.internal.ui.dialogs.FilterOptions;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FilterOptionsDialog
extends Dialog {
    private static final String SEPARATOR = ",";
    private Button enablePluginPatterns;
    private Button keysWithMissingEntriesOnly;
    private Text pluginPatterns;
    private FilterOptions initialOptions;
    private FilterOptions result;

    public FilterOptionsDialog(Shell shell) {
        super(shell);
    }

    public void setInitialFilterOptions(FilterOptions initialfilterOptions) {
        this.initialOptions = initialfilterOptions;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Filters");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.enablePluginPatterns = new Button(composite, 32);
        this.enablePluginPatterns.setFocus();
        this.enablePluginPatterns.setText("Filter by plug-in id patterns (separated by comma):");
        this.enablePluginPatterns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterOptionsDialog.this.pluginPatterns.setEnabled(FilterOptionsDialog.this.enablePluginPatterns.getSelection());
            }
        });
        this.enablePluginPatterns.setSelection(this.initialOptions.filterPlugins);
        this.pluginPatterns = new Text(composite, 2052);
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(59);
        this.pluginPatterns.setLayoutData((Object)data);
        this.pluginPatterns.setEnabled(this.initialOptions.filterPlugins);
        if (this.initialOptions.pluginPatterns != null) {
            String[] patterns;
            StringBuilder builder = new StringBuilder();
            String[] stringArray = patterns = this.initialOptions.pluginPatterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                if (builder.length() > 0) {
                    builder.append(SEPARATOR);
                    builder.append(" ");
                }
                builder.append(pattern);
                ++n2;
            }
            this.pluginPatterns.setText(builder.toString());
        }
        this.keysWithMissingEntriesOnly = new Button(composite, 32);
        this.keysWithMissingEntriesOnly.setText("Keys with missing entries only");
        this.keysWithMissingEntriesOnly.setSelection(this.initialOptions.keysWithMissingEntriesOnly);
        FilterOptionsDialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void okPressed() {
        String patterns = this.pluginPatterns.getText();
        this.result = new FilterOptions();
        this.result.filterPlugins = this.enablePluginPatterns.getSelection();
        String[] split = patterns.split(SEPARATOR);
        int i = 0;
        while (i < split.length) {
            split[i] = split[i].trim();
            ++i;
        }
        this.result.pluginPatterns = split;
        this.result.keysWithMissingEntriesOnly = this.keysWithMissingEntriesOnly.getSelection();
        super.okPressed();
    }

    public FilterOptions getResult() {
        return this.result;
    }
}

