/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.nls.internal.ui.parser;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.pde.nls.internal.ui.parser.IScannerSource;
import org.eclipse.pde.nls.internal.ui.parser.LexicalErrorException;

public class CharArraySource
implements IScannerSource {
    private char[] cbuf;
    private int end;
    private int[] lineEnds = new int[2048];
    int currentPosition = 0;
    int currentLineNumber = 1;

    protected CharArraySource() {
    }

    public CharArraySource(char[] cbuf) {
        this.cbuf = cbuf;
        this.end = cbuf.length;
    }

    protected void reset(char[] cbuf, int begin, int end) {
        if (cbuf == null) {
            this.cbuf = null;
            this.end = -1;
            this.currentPosition = -1;
            this.currentLineNumber = -1;
            this.lineEnds = null;
        } else {
            this.cbuf = cbuf;
            this.end = end;
            this.currentPosition = begin;
            this.currentLineNumber = 1;
            this.lineEnds = new int[2];
        }
    }

    @Override
    public int charAt(int index) {
        if (index < this.end) {
            return this.cbuf[index];
        }
        return -1;
    }

    @Override
    public int lookahead() {
        if (this.currentPosition < this.end) {
            return this.cbuf[this.currentPosition];
        }
        return -1;
    }

    @Override
    public int lookahead(int n) {
        int pos = this.currentPosition + n - 1;
        if (pos < this.end) {
            return this.cbuf[pos];
        }
        return -1;
    }

    @Override
    public int readChar() {
        if (this.currentPosition < this.end) {
            return this.cbuf[this.currentPosition++];
        }
        ++this.currentPosition;
        return -1;
    }

    @Override
    public int readChar(int expected) {
        int c = this.readChar();
        if (c == expected) {
            return c;
        }
        String message = "Expected char '" + (char)expected + "' (0x" + CharArraySource.hexDigit(expected >> 4 & 0xF) + CharArraySource.hexDigit(expected & 0xF) + ") but got '" + (char)c + "' (0x" + CharArraySource.hexDigit(c >> 4 & 0xF) + CharArraySource.hexDigit(c & 0xF) + ")";
        throw new LexicalErrorException(this, message);
    }

    @Override
    public void unreadChar() {
        --this.currentPosition;
    }

    @Override
    public boolean hasMoreChars() {
        return this.currentPosition < this.end;
    }

    @Override
    public int getPosition() {
        if (this.currentPosition < this.end) {
            return this.currentPosition;
        }
        return this.end;
    }

    @Override
    public boolean isAtLineBegin() {
        return this.currentPosition == this.lineEnds[this.currentLineNumber - 1];
    }

    @Override
    public int getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    @Override
    public int getCurrentColumnNumber() {
        return this.currentPosition - this.lineEnds[this.currentLineNumber - 1] + 1;
    }

    @Override
    public int[] getLineEnds() {
        return this.lineEnds;
    }

    @Override
    public void pushLineSeparator() {
        if (this.currentLineNumber >= this.lineEnds.length) {
            int[] newLineEnds = new int[this.lineEnds.length * 2];
            System.arraycopy(this.lineEnds, 0, newLineEnds, 0, this.lineEnds.length);
            this.lineEnds = newLineEnds;
        }
        this.lineEnds[this.currentLineNumber++] = this.currentPosition;
    }

    public int length() {
        return this.cbuf.length;
    }

    public String toString(int beginIndex) {
        return this.toString(beginIndex, this.currentPosition);
    }

    @Override
    public String toString(int beginIndex, int endIndex) {
        return new String(this.cbuf, beginIndex, endIndex - beginIndex);
    }

    public char[] getArray() {
        return this.cbuf;
    }

    public String toString() {
        return "Line=" + this.getCurrentLineNumber() + ", Column=" + this.getCurrentColumnNumber();
    }

    private static char hexDigit(int digit) {
        return "0123456789abcdef".charAt(digit);
    }

    public static CharArraySource createFrom(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int BUF_SIZE = 4096;
        char[] array = new char[BUF_SIZE];
        int read = 0;
        while ((read = reader.read(array, 0, BUF_SIZE)) > 0) {
            buffer.append(array, 0, read);
        }
        char[] result = new char[buffer.length()];
        buffer.getChars(0, buffer.length(), result, 0);
        return new CharArraySource(result);
    }
}

