/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.nls.internal.ui.parser;

import java.util.Locale;
import java.util.StringTokenizer;

public class LocaleUtil {
    private LocaleUtil() {
    }

    public static Locale parseLocale(String name) throws IllegalArgumentException {
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = new StringTokenizer(name, "_");
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            variant = tokenizer.nextToken();
        }
        if (!language.equals("") && language.length() != 2) {
            throw new IllegalArgumentException();
        }
        if (!country.equals("") && country.length() != 2) {
            throw new IllegalArgumentException();
        }
        if (!language.equals("")) {
            char l1 = language.charAt(0);
            char l2 = language.charAt(1);
            if ('a' > l1 || l1 > 'z' || 'a' > l2 || l2 > 'z') {
                throw new IllegalArgumentException();
            }
        }
        if (!country.equals("")) {
            char c1 = country.charAt(0);
            char c2 = country.charAt(1);
            if ('A' > c1 || c1 > 'Z' || 'A' > c2 || c2 > 'Z') {
                throw new IllegalArgumentException();
            }
        }
        return new Locale(language, country, variant);
    }
}

