/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.jrexpressions.ui.test;

import com.google.inject.Injector;
import com.jaspersoft.studio.editor.jrexpressions.ui.JRExpressionsActivator;
import de.itemis.xtext.utils.jface.viewers.StyledTextXtextAdapter;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.nodemodel.BidiIterable;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNode;
import org.eclipse.xtext.nodemodel.impl.RootNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.ParseException;

public class ExpEditorDialog
extends PersistentLocationDialog {
    private StyledTextXtextAdapter xtextAdapter;
    private TreeViewer debugtree;
    private StyledText editorArea;
    private CaretListener editorCaretListener;
    private SelectionListener editorSelectionListener;
    private SelectionListener treeSelectionListener;
    private ModifyListener editorModifyListener;

    public ExpEditorDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(66736);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createEditorArea(container);
        this.createDebugTreeViewer(container);
        this.createListeners();
        this.addTextEditorListeners();
        this.addTreeListeners();
        return container;
    }

    private void addTreeListeners() {
        this.debugtree.getTree().addSelectionListener(this.treeSelectionListener);
    }

    private void addTextEditorListeners() {
        this.editorArea.addSelectionListener(this.editorSelectionListener);
        this.editorArea.addCaretListener(this.editorCaretListener);
        this.editorArea.addModifyListener(this.editorModifyListener);
    }

    private void removeTreeListeners() {
        this.debugtree.getTree().removeSelectionListener(this.treeSelectionListener);
    }

    private void removeTextEditorListeners() {
        this.editorArea.removeSelectionListener(this.editorSelectionListener);
        this.editorArea.removeCaretListener(this.editorCaretListener);
        this.editorArea.removeModifyListener(this.editorModifyListener);
    }

    private void createListeners() {
        this.editorSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExpEditorDialog.this.removeTreeListeners();
                TreeItem item = ExpEditorDialog.this.findTreeItemForNode(ExpEditorDialog.this.debugtree.getTree().getItems(), e.x, e.y);
                if (item != null) {
                    ExpEditorDialog.this.debugtree.getTree().select(item);
                } else {
                    ExpEditorDialog.this.debugtree.setSelection(null);
                }
                ExpEditorDialog.this.addTreeListeners();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.editorCaretListener = new CaretListener(){

            public void caretMoved(CaretEvent event) {
                ExpEditorDialog.this.removeTreeListeners();
                TreeItem item = ExpEditorDialog.this.findTreeItemForNode(ExpEditorDialog.this.debugtree.getTree().getItems(), event.caretOffset, event.caretOffset);
                if (item != null) {
                    ExpEditorDialog.this.debugtree.getTree().select(item);
                } else {
                    ExpEditorDialog.this.debugtree.setSelection(null);
                }
                ExpEditorDialog.this.addTreeListeners();
            }
        };
        this.treeSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                INode iNode;
                ExpEditorDialog.this.removeTextEditorListeners();
                TreeItem[] selection = ((Tree)e.getSource()).getSelection();
                if (selection != null && selection.length == 1 && (iNode = (INode)selection[0].getData()) != null) {
                    int nodeOffset = iNode.getOffset();
                    int nodeLength = iNode.getLength();
                    ExpEditorDialog.this.editorArea.setSelection(nodeOffset, nodeOffset + nodeLength);
                }
                ExpEditorDialog.this.addTextEditorListeners();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.editorModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    IParseResult xtextParseResult = ExpEditorDialog.this.xtextAdapter.getXtextParseResult();
                    if (xtextParseResult != null) {
                        ICompositeNode rootNode = xtextParseResult.getRootNode();
                        ExpEditorDialog.this.debugtree.setInput((Object)rootNode);
                        ExpEditorDialog.this.debugtree.expandAll();
                    }
                }
                catch (ParseException parseException) {
                    ExpEditorDialog.this.debugtree.getTree().removeAll();
                }
            }
        };
    }

    private TreeItem findTreeItemForNode(TreeItem[] items, int selectionStart, int selectionEnd) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            TreeItem found = null;
            if (item.getData() instanceof INode) {
                TreeItem foundChildren;
                INode currNode = (INode)item.getData();
                int currOffset = currNode.getOffset();
                int currLength = currNode.getLength();
                int selectionLength = selectionEnd - selectionStart;
                if (currOffset == selectionStart && (currLength == selectionLength || selectionLength == 0)) {
                    found = item;
                }
                if (item.getItemCount() > 0 && (foundChildren = this.findTreeItemForNode(item.getItems(), selectionStart, selectionEnd)) != null) {
                    found = foundChildren;
                }
            }
            if (found != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }

    private void createEditorArea(Composite parent) {
        Composite editorContainer = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.heightHint = 70;
        editorContainer.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        editorContainer.setLayout((Layout)layout);
        this.editorArea = new StyledText(editorContainer, 2053);
        this.editorArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.xtextAdapter = new StyledTextXtextAdapter(this.getInjector());
        this.xtextAdapter.adapt(this.editorArea);
    }

    private void createDebugTreeViewer(Composite container) {
        this.debugtree = new TreeViewer(container, 2053);
        this.debugtree.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.debugtree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (element != null && element instanceof ICompositeNode) {
                    return ((ICompositeNode)element).hasChildren();
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof RootNode) {
                    return null;
                }
                if (element != null && element instanceof INode) {
                    return ((INode)element).getParent();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                ArrayList<INode> childrenList = new ArrayList<INode>();
                if (parentElement != null && parentElement instanceof ICompositeNode) {
                    BidiIterable children = ((ICompositeNode)parentElement).getChildren();
                    for (INode child : children) {
                        if (child instanceof HiddenLeafNode) continue;
                        childrenList.add(child);
                    }
                }
                return childrenList.toArray(new INode[childrenList.size()]);
            }
        });
        this.debugtree.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof INode) {
                    EObject grammarElement = ((INode)element).getGrammarElement();
                    GrammarElementTitleSwitch testSwitch = new GrammarElementTitleSwitch();
                    String result = testSwitch.doSwitch(grammarElement);
                    String nodetext = ((INode)element).getText();
                    nodetext = nodetext.replace("\n", "\\n");
                    if (result != null) {
                        return String.valueOf(result) + " | [" + nodetext + "]";
                    }
                    return "[" + nodetext + "]";
                }
                return super.getText(element);
            }
        });
    }

    private Injector getInjector() {
        JRExpressionsActivator activator = JRExpressionsActivator.getInstance();
        return activator.getInjector("com.jaspersoft.studio.editor.jrexpressions.JavaJRExpression");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(600, 800);
    }
}

