/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.creation;

import com.jaspersoft.studio.components.customvisualization.creation.ConsoleExecuter;
import java.util.ArrayList;
import java.util.Map;
import net.sf.jasperreports.eclipse.builder.Markers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class CVCBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "com.jaspersoft.studio.cvc.builder";

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        if (currentProject == null || !currentProject.isAccessible()) {
            return;
        }
        monitor.subTask("Cleaning");
        long stime = System.currentTimeMillis();
        this.getProject().accept((IResourceVisitor)new CleanResourceVisitor(monitor));
        long etime = System.currentTimeMillis();
        System.out.println("Cleaned in " + (etime - stime) + " ms");
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        if (currentProject == null) {
            return new IProject[0];
        }
        switch (kind) {
            case 6: {
                this.fullBuild(monitor);
                break;
            }
            case 15: {
                this.clean(monitor);
                break;
            }
            default: {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                    break;
                }
                this.incrementalBuild(delta, monitor);
            }
        }
        return new IProject[0];
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        long stime = System.currentTimeMillis();
        this.getProject().accept((IResourceVisitor)new ResourceVisitor(monitor));
        long etime = System.currentTimeMillis();
        System.out.println("Full Build in " + (etime - stime) + " ms");
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new DeltaVisitor(monitor));
    }

    private IFile compile(IResource resource, IProgressMonitor monitor) {
        if (resource instanceof IFile && resource.getName().equals("build.js")) {
            ArrayList<IFile> files = new ArrayList<IFile>();
            files.add((IFile)resource);
            new ConsoleExecuter(files);
        }
        return null;
    }

    class CleanResourceVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;

        public CleanResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (resource.exists()) {
                if (resource.getName().equals("build.js")) {
                    Markers.deleteMarkers((IResource)resource);
                } else if (resource.getName().equals("min.js")) {
                    resource.delete(false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.monitor));
                }
            }
            return true;
        }
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;

        public DeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            switch (delta.getKind()) {
                case 1: 
                case 2: 
                case 4: {
                    CVCBuilder.this.compile(delta.getResource(), this.monitor);
                }
            }
            return true;
        }
    }

    class ResourceVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;

        public ResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            CVCBuilder.this.compile(resource, this.monitor);
            return true;
        }
    }
}

