/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.creation;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.components.customvisualization.creation.ModuleDefinition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ModuleManager {
    private static final String PREF_KEYS_JS_MODULES = "jsModules";
    private static List<ModuleDefinition> embeddedModules = new ArrayList<ModuleDefinition>();

    static {
        ModuleDefinition d3Circle = new ModuleDefinition();
        d3Circle.setModuleVisualName("Circle Sample based on D3.js library");
        d3Circle.setModuleName("d3Circle");
        d3Circle.setVariableName("d3");
        d3Circle.setLibraryURL("https://raw.githubusercontent.com/mbostock/d3/v3.4.13/d3.min.js");
        d3Circle.setLicenseURL("https://raw.githubusercontent.com/mbostock/d3/v3.4.13/LICENSE");
        d3Circle.setCssResource("com/jaspersoft/studio/components/customvisualization/creation/resources/D3_Circle_css.css");
        d3Circle.setRenderResource("com/jaspersoft/studio/components/customvisualization/creation/resources/D3_Circle_render.js");
        d3Circle.setVersionNumber("3.4.13");
        d3Circle.addSampleResource("com/jaspersoft/studio/components/customvisualization/creation/resources/d3_Circle_sample.jrxml");
        ModuleDefinition raphaelMap = new ModuleDefinition();
        raphaelMap.setModuleVisualName("Map Sample based on Raphael library");
        raphaelMap.setModuleName("RaphaelMap");
        raphaelMap.setCssResource("com/jaspersoft/studio/components/customvisualization/creation/resources/raphael_Map_css.css");
        raphaelMap.setRenderResource("com/jaspersoft/studio/components/customvisualization/creation/resources/raphael_Map_render.js");
        raphaelMap.setLibraryURL("https://raw.githubusercontent.com/DmitryBaranovskiy/raphael/v2.1.2/raphael-min.js");
        raphaelMap.setLicenseURL("https://raw.githubusercontent.com/DmitryBaranovskiy/raphael/v2.1.2/license.txt");
        raphaelMap.setVersionNumber("2.1.2");
        raphaelMap.setVariableName("Raphael");
        raphaelMap.addSampleResource("com/jaspersoft/studio/components/customvisualization/creation/resources/raphael_Map_sample.jrxml");
        ModuleDefinition plainSample = new ModuleDefinition();
        plainSample.setModuleVisualName("Rectangle Sample based on plain javascript");
        plainSample.setModuleName("plain");
        plainSample.setRenderResource("com/jaspersoft/studio/components/customvisualization/creation/resources/plain_render.js");
        plainSample.addSampleResource("com/jaspersoft/studio/components/customvisualization/creation/resources/plain_sample.jrxml");
        embeddedModules.add(d3Circle);
        embeddedModules.add(raphaelMap);
        embeddedModules.add(plainSample);
        ModuleManager.getContributedModules();
    }

    private static void createRaphaelDots() {
        ModuleDefinition raphaelModule = new ModuleDefinition();
        raphaelModule.setModuleName("Raphael Dots");
        raphaelModule.setVariableName("raphael");
        raphaelModule.setLibraryURL("https://raw.githubusercontent.com/DmitryBaranovskiy/raphael/v2.1.2/raphael-min.js");
        raphaelModule.setLicenseURL("https://raw.githubusercontent.com/DmitryBaranovskiy/raphael/v2.1.2/license.txt");
        raphaelModule.setCssResource("com/jaspersoft/studio/components/customvisualization/creation/resources/raphaelDots_css.css");
        raphaelModule.setRenderResource("com/jaspersoft/studio/components/customvisualization/creation/resources/raphaeldots_render.js");
        raphaelModule.setVersionNumber("2.1.2");
        raphaelModule.setNeedShim(true);
        raphaelModule.setShimExportName("Raphael");
        ModuleDefinition gRaphael = new ModuleDefinition();
        gRaphael.setVariableName("g.raphael");
        gRaphael.setModuleName("gRaphael");
        gRaphael.setLibraryURL("https://raw.githubusercontent.com/DmitryBaranovskiy/g.raphael/v0.5/g.raphael.js");
        gRaphael.setLicenseURL("https://raw.githubusercontent.com/DmitryBaranovskiy/raphael/v2.1.2/license.txt");
        gRaphael.setVersionNumber("0.5");
        gRaphael.setNeedShim(true);
        gRaphael.setShimExportName("Raphael");
        gRaphael.addShimDependency("raphael");
        raphaelModule.addRequiredLibrary(gRaphael);
        ModuleDefinition gDot = new ModuleDefinition();
        gDot.setVariableName("g.dot");
        gDot.setModuleName("gDot");
        gDot.setLibraryURL("https://raw.githubusercontent.com/DmitryBaranovskiy/g.raphael/v0.5/g.dot.js");
        gDot.setLicenseURL("https://raw.githubusercontent.com/DmitryBaranovskiy/raphael/v2.1.2/license.txt");
        gDot.setVersionNumber("0.5");
        gDot.setNeedShim(true);
        gDot.setShimExportName("Raphael");
        gDot.addShimDependency("g.raphael");
        raphaelModule.addRequiredLibrary(gDot);
        embeddedModules.add(raphaelModule);
    }

    private static void getContributedModules() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.jaspersoft.studio.components.customvisualization.ComponentSamples");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object input = element.createExecutableExtension("class");
                if (input instanceof ModuleDefinition) {
                    ModuleDefinition module = (ModuleDefinition)input;
                    embeddedModules.add(module);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public static List<ModuleDefinition> getModules() {
        return embeddedModules;
    }

    public static boolean isLocal(ModuleDefinition module) {
        String fileName = ModuleManager.getModuleLibraryFileName(module);
        return ConfigurationManager.getStorageResource((String)PREF_KEYS_JS_MODULES, (String)fileName) != null;
    }

    private static File downloadLibrary(ModuleDefinition module, String fileName) {
        File moduleFile = module.fetchLibrary();
        File storage = ConfigurationManager.getStorage((String)PREF_KEYS_JS_MODULES);
        File destinationFile = new File(storage, fileName);
        try {
            FileUtils.copyFile((File)moduleFile, (File)destinationFile);
            return destinationFile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String readTextfile(File file) {
        try {
            String line;
            String result = "";
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = in.readLine()) != null) {
                result = String.valueOf(result) + line + "\n";
            }
            in.close();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "License Not Found";
        }
    }

    private static File downloadLicense(ModuleDefinition module, String fileName) {
        File moduleFile = module.fetchLicense();
        File storage = ConfigurationManager.getStorage((String)PREF_KEYS_JS_MODULES);
        File destinationFile = new File(storage, fileName);
        try {
            FileUtils.copyFile((File)moduleFile, (File)destinationFile);
            return destinationFile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String getModuleLibraryFileName(ModuleDefinition module) {
        String fileName = module.getLibraryFilename();
        fileName = String.valueOf(fileName.substring(0, fileName.length() - 3)) + module.getLibraryVersionNumber() + ".js";
        return fileName;
    }

    private static String getLicenseFileName(ModuleDefinition module) {
        String fileName = module.getLibraryFilename();
        fileName = String.valueOf(fileName.substring(0, fileName.length() - 3)) + module.getLibraryVersionNumber() + "License.txt";
        return fileName;
    }

    public static File getLibraryFile(ModuleDefinition module) {
        String fileName;
        File storage = ConfigurationManager.getStorage((String)PREF_KEYS_JS_MODULES);
        File resource = ConfigurationManager.getStorageResource((File)storage, (String)(fileName = ModuleManager.getModuleLibraryFileName(module)));
        if (resource == null) {
            resource = ModuleManager.downloadLibrary(module, fileName);
        }
        return resource;
    }

    public static String getLicenseFile(ModuleDefinition module) {
        String fileName;
        File storage = ConfigurationManager.getStorage((String)PREF_KEYS_JS_MODULES);
        File license = ConfigurationManager.getStorageResource((File)storage, (String)(fileName = ModuleManager.getLicenseFileName(module)));
        if (license == null) {
            license = ModuleManager.downloadLicense(module, fileName);
        }
        String result = ModuleManager.readTextfile(license);
        return result;
    }

    public static boolean isLicenseLocal(ModuleDefinition module) {
        String fileName = ModuleManager.getLicenseFileName(module);
        return ConfigurationManager.getStorageResource((String)PREF_KEYS_JS_MODULES, (String)fileName) != null;
    }
}

