/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.figure;

import com.jaspersoft.studio.components.customvisualization.model.MCustomVisualization;
import com.jaspersoft.studio.components.customvisualization.ui.UIManager;
import com.jaspersoft.studio.components.customvisualization.ui.framework.CVCWidgetsDescriptor;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.figures.JRComponentFigure;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.ImageUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.IOException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.ImageData;

public class CVFigure
extends JRComponentFigure {
    private Image cache;

    public CVFigure(MGraphicElement node) {
        super(node);
    }

    public void paint(Graphics graphics) {
        try {
            Image image = this.getPreviewImage();
            if (image != null) {
                Rectangle figureRect = this instanceof HandleBounds ? this.getHandleBounds() : this.getBounds();
                int imgWidth = image.getWidth(null);
                int imgHeight = image.getHeight(null);
                Graphics2D g = ComponentFigure.getG2D((Graphics)graphics);
                if (g != null) {
                    g.setColor(Color.WHITE);
                    g.fillRect(figureRect.x, figureRect.y, figureRect.x + figureRect.width, figureRect.y + figureRect.height);
                    g.drawImage(image, figureRect.x, figureRect.y, figureRect.x + figureRect.width, figureRect.y + figureRect.height, 0, 0, imgWidth, imgHeight, null);
                }
                this.paintBorder(graphics);
                this.paintDecorators(graphics);
            } else {
                super.paint(graphics);
            }
        }
        catch (Exception ex) {
            UIUtils.showError((Throwable)ex);
        }
    }

    private Image getPreviewImage() throws IOException {
        org.eclipse.swt.graphics.Image img;
        if (this.cache != null) {
            return this.cache;
        }
        CVCWidgetsDescriptor cd = UIManager.getComponentDescriptor((MCustomVisualization)this.model);
        if (cd != null && (img = UIManager.getThumbnail(cd)) != null) {
            this.cache = ImageUtils.convertToAWT((ImageData)img.getImageData());
            return this.cache;
        }
        return null;
    }

    protected boolean allowsFigureDrawCache() {
        return true;
    }
}

