/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.model.command;

import com.jaspersoft.studio.components.customvisualization.CustomVisualizationActivator;
import com.jaspersoft.studio.components.customvisualization.ui.UIManager;
import com.jaspersoft.studio.components.customvisualization.ui.framework.CVCWidgetsDescriptor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.nebula.widgets.gallery.RoundedGalleryItemRenderer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;

public class CVCTypeWizardPage
extends JSSWizardPage {
    private static final int GALLERY_HEIGHT = 100;
    private static final int GALLERY_WIDTH = 100;
    private List<CVCWidgetsDescriptor> modules;
    private CVCWidgetsDescriptor module;
    private Scale zoomFactor;
    private Gallery chartsGallery;
    private GalleryItem itemGroup;

    protected CVCTypeWizardPage(List<CVCWidgetsDescriptor> modules) {
        super("cvcwizard");
        this.setTitle("Custom Visualisation Components");
        this.setDescription("Select one Custom Visualisation Component from the list.");
        this.modules = modules;
    }

    public CVCWidgetsDescriptor getModule() {
        return this.module;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)composite);
        this.zoomFactor = new Scale(composite, 0);
        this.zoomFactor.setMinimum(1);
        this.zoomFactor.setMaximum(50);
        this.zoomFactor.setIncrement(1);
        this.zoomFactor.setPageIncrement(5);
        this.zoomFactor.setSelection(1);
        GridData gd = new GridData(128);
        gd.widthHint = 150;
        this.zoomFactor.setLayoutData((Object)gd);
        this.chartsGallery = new Gallery(composite, 0x10000A00);
        final NoGroupRenderer gr = new NoGroupRenderer();
        gr.setMinMargin(2);
        gr.setItemSize(100, 100);
        gr.setAutoMargin(true);
        gd = new GridData(1808);
        gd.widthHint = 500;
        this.chartsGallery.setLayoutData((Object)gd);
        this.chartsGallery.setGroupRenderer((AbstractGalleryGroupRenderer)gr);
        RoundedGalleryItemRenderer ir = new RoundedGalleryItemRenderer();
        ir.setShowLabels(true);
        this.chartsGallery.setItemRenderer((AbstractGalleryItemRenderer)ir);
        this.itemGroup = new GalleryItem(this.chartsGallery, 0);
        this.fillTableb4j(this.chartsGallery, this.itemGroup);
        this.chartsGallery.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("Selection changed..." + e.item);
                CVCTypeWizardPage.this.module = e.item != null && e.item instanceof GalleryItem ? (CVCWidgetsDescriptor)((Object)((GalleryItem)e.item).getData()) : null;
                CVCTypeWizardPage.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setTableSelection();
        SelectionAdapter sa = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                double c = 1.0 + 0.1 * (double)CVCTypeWizardPage.this.zoomFactor.getSelection();
                gr.setItemSize((int)(100.0 * c), (int)(100.0 * c));
            }
        };
        this.zoomFactor.addSelectionListener((SelectionListener)sa);
        sa.widgetSelected(null);
    }

    private void setTableSelection() {
        GalleryItem[] galleryItemArray = this.itemGroup.getItems();
        int n = galleryItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            GalleryItem ti = galleryItemArray[n2];
            if (ti.getData() == this.module) {
                this.chartsGallery.setSelection(new GalleryItem[]{ti});
                break;
            }
            ++n2;
        }
    }

    private void fillTableb4j(Gallery table, GalleryItem rootItem) {
        table.setRedraw(false);
        GalleryItem tib = new GalleryItem(rootItem, 0);
        tib.setText("Blank");
        CVCTypeWizardPage.setGallyeryItemImageInfo(tib, "icons/blank_a4.png");
        JasperReportsConfiguration jConf = this.getConfig();
        Collections.sort(this.modules, new Comparator<CVCWidgetsDescriptor>(){

            @Override
            public int compare(CVCWidgetsDescriptor o1, CVCWidgetsDescriptor o2) {
                return o1.getLocalizedString(o1.getLabel()).compareTo(o2.getLocalizedString(o2.getLabel()));
            }
        });
        for (CVCWidgetsDescriptor cd : this.modules) {
            GalleryItem ti = new GalleryItem(rootItem, 0);
            ti.setText(cd.getLocalizedString(cd.getLabel()));
            CVCTypeWizardPage.setGallyeryItemImageInfo(ti, cd, jConf);
            ti.setData((Object)cd);
        }
        table.setRedraw(true);
    }

    private static void setGallyeryItemImageInfo(GalleryItem item, CVCWidgetsDescriptor cd, JasperReportsConfiguration jConf) {
        Image img;
        if (!Misc.isNullOrEmpty((String)cd.getThumbnail()) && (img = UIManager.getThumbnail(cd)) != null) {
            item.setSelectedImage(img);
            item.setStandardImage(img);
            item.setImage(img);
            return;
        }
        CVCTypeWizardPage.setGallyeryItemImageInfo(item, "icons/blank_a4.png");
    }

    private static void setGallyeryItemImageInfo(GalleryItem item, String imagePath) {
        Image img = CustomVisualizationActivator.getDefault().getImage(imagePath);
        if (img != null) {
            item.setSelectedImage(img);
            item.setStandardImage(img);
            item.setImage(img);
        }
    }

    protected String getContextName() {
        return "";
    }

    public boolean isPageComplete() {
        return this.chartsGallery.getSelectionCount() > 0;
    }
}

